/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.wsif;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jbi.messaging.MessageExchange;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.servicemix.components.wsif.WSIFOperationInfo;
import org.apache.servicemix.jbi.NoSuchOperationException;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFService;

public class WSIFOperationMap {
    private WSIFService service;
    private Map operationMap = new HashMap();
    private WSIFOperationInfo defaultOperation;

    public WSIFOperationMap(WSIFService service) {
        this.service = service;
    }

    public WSIFOperationInfo getOperationForExchange(MessageExchange exchange) throws NoSuchOperationException {
        QName operationName = exchange.getOperation();
        WSIFOperationInfo operationInfo = this.getOperation(operationName);
        if (operationInfo == null) {
            throw new NoSuchOperationException(operationName);
        }
        return operationInfo;
    }

    public WSIFOperationInfo getOperation(QName operationName) {
        if (operationName == null) {
            return this.defaultOperation;
        }
        return (WSIFOperationInfo)this.operationMap.get(operationName);
    }

    public int getOperationCount() {
        return this.operationMap.values().size();
    }

    public WSIFOperationInfo getOperation(String operationName) {
        return (WSIFOperationInfo)this.operationMap.get(operationName);
    }

    public void addBinding(Binding binding) throws WSIFException {
        List list = binding.getBindingOperations();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            BindingOperation bindingOperation = (BindingOperation)iter.next();
            this.addBindingOperation(binding, bindingOperation);
        }
    }

    protected void addBindingOperation(Binding binding, BindingOperation bindingOperation) throws WSIFException {
        Operation operation = bindingOperation.getOperation();
        String name = operation.getName();
        WSIFOperationInfo info = new WSIFOperationInfo(this.service.getPort(), name);
        this.operationMap.put(name, info);
        this.operationMap.put(new QName(name), info);
        if (this.defaultOperation == null) {
            this.defaultOperation = info;
        }
    }
}

