/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.server.repository;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.xbean.server.repository.Repository;

public class FileSystemRepository
implements Repository {
    private File root;

    public FileSystemRepository() {
    }

    public FileSystemRepository(File root) {
        this.root = root;
    }

    public File getRoot() {
        return this.root;
    }

    public void setRoot(File root) {
        this.root = root;
    }

    public URL getResource(String location) {
        File root = this.root;
        if (root == null) {
            throw new NullPointerException("root directory is null");
        }
        URI uri = root.toURI().resolve(location);
        File file = new File(uri);
        if (!file.canRead()) {
            return null;
        }
        try {
            return file.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed resource " + uri);
        }
    }
}

