/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.server.spring.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.xbean.kernel.Kernel;
import org.apache.xbean.kernel.ServiceAlreadyExistsException;
import org.apache.xbean.kernel.ServiceFactory;
import org.apache.xbean.kernel.ServiceName;
import org.apache.xbean.kernel.ServiceNotFoundException;
import org.apache.xbean.kernel.ServiceRegistrationException;
import org.apache.xbean.kernel.StaticServiceFactory;
import org.apache.xbean.kernel.StringServiceName;
import org.apache.xbean.spring.context.SpringApplicationContext;

public class SpringConfiguration {
    private final SpringApplicationContext applicationContext;
    private final Map serviceFactories;
    private final Kernel kernel;
    static /* synthetic */ Class class$org$apache$xbean$server$spring$loader$SpringLoader;

    public SpringConfiguration(SpringApplicationContext applicationContext, Kernel kernel) throws Exception {
        this.applicationContext = applicationContext;
        this.kernel = kernel;
        ClassLoader classLoader = SpringConfiguration.getClassLoader(applicationContext);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        applicationContext.refresh();
        try {
            Map.Entry entry;
            Map serviceNameIndex = SpringConfiguration.buildServiceNameIndex(applicationContext);
            HashMap<ServiceName, StaticServiceFactory> factories = new HashMap<ServiceName, StaticServiceFactory>(serviceNameIndex.size());
            Iterator iterator = serviceNameIndex.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                String beanName = (String)entry.getKey();
                ServiceName serviceName = (ServiceName)entry.getValue();
                Object bean = applicationContext.getBean(beanName);
                StaticServiceFactory serviceFactory = new StaticServiceFactory(bean);
                factories.put(serviceName, serviceFactory);
            }
            this.serviceFactories = Collections.unmodifiableMap(factories);
            iterator = this.serviceFactories.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                ServiceName serviceName = (ServiceName)entry.getKey();
                StaticServiceFactory serviceFactory = (StaticServiceFactory)entry.getValue();
                kernel.registerService(serviceName, (ServiceFactory)serviceFactory, classLoader);
            }
        }
        catch (ServiceAlreadyExistsException e) {
            this.destroy();
            throw e;
        }
        catch (ServiceRegistrationException e) {
            this.destroy();
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public String getId() {
        return this.applicationContext.getDisplayName();
    }

    public Map getServiceFactories() {
        return this.serviceFactories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SpringConfiguration.getClassLoader(this.applicationContext));
        try {
            Iterator iterator = this.serviceFactories.keySet().iterator();
            while (iterator.hasNext()) {
                ServiceName serviceName = (ServiceName)iterator.next();
                try {
                    this.kernel.unregisterService(serviceName);
                }
                catch (ServiceNotFoundException e) {
                }
                catch (ServiceRegistrationException e) {}
            }
            this.applicationContext.close();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private static Map buildServiceNameIndex(SpringApplicationContext applicationContext) {
        String[] beanNames = applicationContext.getBeanDefinitionNames();
        HashMap<String, StringServiceName> serviceNameIndex = new HashMap<String, StringServiceName>(beanNames.length);
        for (int i = 0; i < beanNames.length; ++i) {
            String beanName = beanNames[i];
            StringServiceName serviceName = new StringServiceName(beanName);
            serviceNameIndex.put(beanName, serviceName);
        }
        return serviceNameIndex;
    }

    private static ClassLoader getClassLoader(SpringApplicationContext applicationContext) {
        ClassLoader classLoader = applicationContext.getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = (class$org$apache$xbean$server$spring$loader$SpringLoader == null ? (class$org$apache$xbean$server$spring$loader$SpringLoader = SpringConfiguration.class$("org.apache.xbean.server.spring.loader.SpringLoader")) : class$org$apache$xbean$server$spring$loader$SpringLoader).getClassLoader();
        }
        return classLoader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

