/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.beanflow;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.servicemix.beanflow.AbstractActivity;
import org.apache.servicemix.beanflow.DefaultState;
import org.apache.servicemix.beanflow.State;

public class TimeoutActivity
extends AbstractActivity {
    private State<Boolean> timedOut = new DefaultState<Boolean>(Boolean.FALSE);
    private TimerTask timeoutTask;

    public void onTimedOut() {
        if (!this.isStopped()) {
            this.timedOut.set(Boolean.TRUE);
        }
    }

    public void run() {
        if (!this.isStopped()) {
            if (this.timedOut.get().booleanValue()) {
                this.fail("Timed out");
            } else {
                this.onValidStateChange();
            }
        }
    }

    public boolean isTimedOut() {
        return this.timedOut.get();
    }

    public void startWithTimeout(Timer timer, long timeout) {
        this.scheduleTimeout(timer, timeout);
        this.start();
    }

    public void scheduleTimeout(Timer timer, long timeout) {
        if (timeout > 0L) {
            timer.schedule(this.getTimeoutTask(), timeout);
        }
    }

    public TimerTask getTimeoutTask() {
        if (this.timeoutTask == null) {
            this.timeoutTask = new TimerTask(){

                public void run() {
                    TimeoutActivity.this.onTimedOut();
                }
            };
        }
        return this.timeoutTask;
    }

    protected void onValidStateChange() {
    }
}

