/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.beanflow.util;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.servicemix.beanflow.JoinAll;
import org.apache.servicemix.beanflow.JoinSupport;
import org.apache.servicemix.beanflow.ParallelActivity;

public abstract class ParallelBean {
    private ParallelActivity activity;
    private Executor executor;
    private JoinSupport join;
    private int maxThreadPoolSize = 20;

    public ParallelBean() {
    }

    public ParallelBean(Executor executor) {
        this.executor = executor;
    }

    public ParallelBean(Executor executor, JoinSupport join) {
        this.executor = executor;
        this.join = join;
    }

    public void start() {
        this.getActivity().start();
    }

    public void sync() {
        this.getActivity().sync();
    }

    public boolean sync(long millis) {
        return this.getActivity().sync(millis);
    }

    public ParallelActivity getActivity() {
        if (this.activity == null) {
            this.activity = this.createActivity();
        }
        return this.activity;
    }

    public Executor getExecutor() {
        if (this.executor == null) {
            this.executor = this.createExecutor();
        }
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public JoinSupport getJoin() {
        if (this.join == null) {
            this.join = this.createJoin();
        }
        return this.join;
    }

    public void setJoin(JoinSupport join) {
        this.join = join;
    }

    protected ParallelActivity createActivity() {
        return ParallelActivity.newParallelMethodActivity(this.getJoin(), this.getExecutor(), this);
    }

    protected Executor createExecutor() {
        return Executors.newFixedThreadPool(this.maxThreadPoolSize);
    }

    protected JoinSupport createJoin() {
        return new JoinAll();
    }

    protected void sleep(int timeout) {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

