/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.beanflow.util;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.servicemix.beanflow.JoinAll;
import org.apache.servicemix.beanflow.JoinSupport;
import org.apache.servicemix.beanflow.ParallelActivity;
import org.apache.servicemix.beanflow.util.ActivityTestSupport;

public abstract class ParallelTestCase
extends ActivityTestSupport {
    private ParallelActivity activity;
    private Executor executor;
    private JoinSupport join;
    private int maxThreadPoolSize = 20;
    private long testTimeout = 10000L;

    public void testParallelMethods() throws Exception {
        this.startActivity(this.getActivity(), this.testTimeout);
        this.getActivity().join();
        this.assertStopped(this.getActivity());
    }

    public void sync() {
        this.getActivity().sync();
    }

    public boolean sync(long millis) {
        return this.getActivity().sync(millis);
    }

    public ParallelActivity getActivity() {
        if (this.activity == null) {
            this.activity = this.createActivity();
        }
        return this.activity;
    }

    public Executor getExecutor() {
        if (this.executor == null) {
            this.executor = this.createExecutor();
        }
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public JoinSupport getJoin() {
        if (this.join == null) {
            this.join = this.createJoin();
        }
        return this.join;
    }

    public void setJoin(JoinSupport join) {
        this.join = join;
    }

    public int getMaxThreadPoolSize() {
        return this.maxThreadPoolSize;
    }

    public void setMaxThreadPoolSize(int maxThreadPoolSize) {
        this.maxThreadPoolSize = maxThreadPoolSize;
    }

    protected ParallelActivity createActivity() {
        return ParallelActivity.newParallelMethodActivity(this.getJoin(), this.getExecutor(), (Object)this);
    }

    protected Executor createExecutor() {
        return Executors.newFixedThreadPool(this.maxThreadPoolSize);
    }

    protected JoinSupport createJoin() {
        return new JoinAll();
    }

    protected void sleep(int timeout) {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

