/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.transaction.SystemException;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.ConnectorMethodInterceptor;
import org.apache.geronimo.connector.ResourceAdapterWrapper;
import org.apache.geronimo.connector.outbound.ConnectionManagerContainer;
import org.apache.geronimo.gbean.DynamicGBean;
import org.apache.geronimo.gbean.DynamicGBeanDelegate;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.management.geronimo.JCAManagedConnectionFactory;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.ResourceManager;

public class ManagedConnectionFactoryWrapper
implements GBeanLifecycle,
DynamicGBean,
ResourceManager,
JCAManagedConnectionFactory {
    private static final Log log = LogFactory.getLog((Class)ManagedConnectionFactoryWrapper.class);
    private final String managedConnectionFactoryClass;
    private final String connectionFactoryInterface;
    private final String[] implementedInterfaces;
    private final String connectionFactoryImplClass;
    private final String connectionInterface;
    private final String connectionImplClass;
    private final Class[] allImplementedInterfaces;
    private final ResourceAdapterWrapper resourceAdapterWrapper;
    private final ConnectionManagerContainer connectionManagerContainer;
    private ManagedConnectionFactory managedConnectionFactory;
    private Object connectionFactory;
    private DynamicGBeanDelegate delegate;
    private boolean registered = false;
    private Object proxy;
    private ConnectorMethodInterceptor interceptor;
    private final Kernel kernel;
    private final String objectName;
    private final boolean isProxyable;
    private final ClassLoader classLoader;

    public ManagedConnectionFactoryWrapper() {
        this.managedConnectionFactoryClass = null;
        this.connectionFactoryInterface = null;
        this.implementedInterfaces = null;
        this.connectionFactoryImplClass = null;
        this.connectionInterface = null;
        this.connectionImplClass = null;
        this.kernel = null;
        this.objectName = null;
        this.allImplementedInterfaces = null;
        this.isProxyable = false;
        this.classLoader = null;
        this.resourceAdapterWrapper = null;
        this.connectionManagerContainer = null;
    }

    public ManagedConnectionFactoryWrapper(String managedConnectionFactoryClass, String connectionFactoryInterface, String[] implementedInterfaces, String connectionFactoryImplClass, String connectionInterface, String connectionImplClass, ResourceAdapterWrapper resourceAdapterWrapper, ConnectionManagerContainer connectionManagerContainer, Kernel kernel, String objectName, ClassLoader cl) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.managedConnectionFactoryClass = managedConnectionFactoryClass;
        this.connectionFactoryInterface = connectionFactoryInterface;
        this.implementedInterfaces = implementedInterfaces;
        this.connectionFactoryImplClass = connectionFactoryImplClass;
        this.connectionInterface = connectionInterface;
        this.connectionImplClass = connectionImplClass;
        this.allImplementedInterfaces = new Class[1 + implementedInterfaces.length];
        this.allImplementedInterfaces[0] = cl.loadClass(connectionFactoryInterface);
        for (int i = 0; i < implementedInterfaces.length; ++i) {
            this.allImplementedInterfaces[i + 1] = cl.loadClass(implementedInterfaces[i]);
        }
        boolean mightBeProxyable = true;
        for (int i = 0; i < this.allImplementedInterfaces.length; ++i) {
            Class implementedInterface = this.allImplementedInterfaces[i];
            if (implementedInterface.isInterface()) continue;
            mightBeProxyable = false;
            break;
        }
        this.isProxyable = mightBeProxyable;
        this.resourceAdapterWrapper = resourceAdapterWrapper;
        this.connectionManagerContainer = connectionManagerContainer;
        this.classLoader = cl;
        Class<?> clazz = cl.loadClass(managedConnectionFactoryClass);
        this.managedConnectionFactory = (ManagedConnectionFactory)clazz.newInstance();
        this.delegate = new DynamicGBeanDelegate();
        this.delegate.addAll((Object)this.managedConnectionFactory);
        this.kernel = kernel;
        this.objectName = objectName;
    }

    public String getManagedConnectionFactoryClass() {
        return this.managedConnectionFactoryClass;
    }

    public String getConnectionFactoryInterface() {
        return this.connectionFactoryInterface;
    }

    public String[] getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public String getConnectionFactoryImplClass() {
        return this.connectionFactoryImplClass;
    }

    public String getConnectionInterface() {
        return this.connectionInterface;
    }

    public String getConnectionImplClass() {
        return this.connectionImplClass;
    }

    public ResourceAdapterWrapper getResourceAdapterWrapper() {
        return this.resourceAdapterWrapper;
    }

    public ConnectionManagerContainer getConnectionManagerFactory() {
        return this.connectionManagerContainer;
    }

    public String getConnectionManager() {
        try {
            ObjectName mine = ObjectName.getInstance(this.objectName);
            Properties other = new Properties();
            other.setProperty("J2EEApplication", mine.getKeyProperty("J2EEApplication"));
            other.setProperty("J2EEServer", mine.getKeyProperty("J2EEServer"));
            other.setProperty("JCAResource", mine.getKeyProperty("JCAResource"));
            other.setProperty("j2eeType", "JCAConnectionManager");
            other.setProperty("name", mine.getKeyProperty("name"));
            return new ObjectName(mine.getDomain(), other).getCanonicalName();
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)"Unable to construct ObjectName", (Throwable)e);
            return null;
        }
    }

    public void doStart() throws Exception {
        if (!this.registered && this.managedConnectionFactory instanceof ResourceAdapterAssociation) {
            if (this.resourceAdapterWrapper == null) {
                throw new IllegalStateException("Managed connection factory expects to be registered with a ResourceAdapter, but there is no ResourceAdapter");
            }
            this.resourceAdapterWrapper.registerResourceAdapterAssociation((ResourceAdapterAssociation)this.managedConnectionFactory);
            this.registered = true;
            log.debug((Object)("Registered managedConnectionFactory with ResourceAdapter " + this.resourceAdapterWrapper.toString()));
        }
        this.connectionFactory = this.connectionManagerContainer.createConnectionFactory(this.managedConnectionFactory);
        if (this.isProxyable) {
            Enhancer enhancer = new Enhancer();
            enhancer.setInterfaces(this.allImplementedInterfaces);
            enhancer.setCallbackType(MethodInterceptor.class);
            enhancer.setUseFactory(false);
            this.interceptor = new ConnectorMethodInterceptor(this.kernel.getKernelName(), ObjectName.getInstance(this.objectName));
            enhancer.setCallbacks(new Callback[]{this.interceptor});
            this.proxy = enhancer.create(new Class[0], new Object[0]);
        } else {
            this.proxy = this.connectionFactory;
        }
        if (this.interceptor != null) {
            this.interceptor.setInternalProxy(this.connectionFactory);
        }
    }

    public void doStop() {
        if (this.interceptor != null) {
            this.interceptor.setInternalProxy(null);
        }
        this.connectionFactory = null;
    }

    public void doFail() {
        this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldTCL = thread.getContextClassLoader();
        thread.setContextClassLoader(this.classLoader);
        try {
            Object object = this.delegate.getAttribute(name);
            return object;
        }
        finally {
            thread.setContextClassLoader(oldTCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldTCL = thread.getContextClassLoader();
        thread.setContextClassLoader(this.classLoader);
        try {
            this.delegate.setAttribute(name, value);
        }
        finally {
            thread.setContextClassLoader(oldTCL);
        }
    }

    public Object invoke(String name, Object[] arguments, String[] types) throws Exception {
        return null;
    }

    public Object getConnectionFactory() {
        return this.$getResource();
    }

    public Object $getResource() {
        return this.proxy;
    }

    public Object $getConnectionFactory() {
        return this.connectionFactory;
    }

    public ManagedConnectionFactory $getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    public Map getConfigProperties() {
        String[] props = this.delegate.getProperties();
        HashMap<String, Class> map = new HashMap<String, Class>();
        for (int i = 0; i < props.length; ++i) {
            String prop = props[i];
            if (prop.equals("logWriter")) continue;
            map.put(prop, this.delegate.getPropertyType(prop));
        }
        return map;
    }

    public void setConfigProperty(String property, Object value) throws Exception {
        Class cls = this.delegate.getPropertyType(property);
        if (value != null && value instanceof String && !cls.getName().equals("java.lang.String")) {
            if (cls.isPrimitive()) {
                if (cls.equals(Integer.TYPE)) {
                    cls = Integer.class;
                } else if (cls.equals(Boolean.TYPE)) {
                    cls = Boolean.class;
                } else if (cls.equals(Float.TYPE)) {
                    cls = Float.class;
                } else if (cls.equals(Double.TYPE)) {
                    cls = Double.class;
                } else if (cls.equals(Long.TYPE)) {
                    cls = Long.class;
                } else if (cls.equals(Short.TYPE)) {
                    cls = Short.class;
                } else if (cls.equals(Byte.TYPE)) {
                    cls = Byte.class;
                } else if (cls.equals(Character.TYPE)) {
                    cls = Character.class;
                }
            }
            Constructor con = cls.getConstructor(String.class);
            value = con.newInstance(value);
        }
        this.kernel.setAttribute(ObjectName.getInstance(this.objectName), property, value);
    }

    public Object getConfigProperty(String property) throws Exception {
        return this.delegate.getAttribute(property);
    }

    public NamedXAResource getRecoveryXAResources() throws SystemException {
        try {
            return this.connectionManagerContainer.getRecoveryXAResource(this.managedConnectionFactory);
        }
        catch (ResourceException e) {
            throw (SystemException)new SystemException("Could not obtain recovery XAResource for managedConnectionFactory " + this.objectName).initCause((Throwable)e);
        }
    }

    public void returnResource(NamedXAResource xaResource) {
        ((ConnectionManagerContainer.ReturnableXAResource)xaResource).returnConnection();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return false;
    }
}

