/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound.security;

import java.io.IOException;
import java.util.Map;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.connector.outbound.security.ResourcePrincipal;

public class CallerIdentityPasswordCredentialLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private ManagedConnectionFactory managedConnectionFactory;
    private String resourcePrincipalName;
    private String userName;
    private char[] password;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.managedConnectionFactory = (ManagedConnectionFactory)options.get("geronimo.managedconnectionfactory.option");
        if (this.managedConnectionFactory == null) {
            throw new IllegalArgumentException("No ManagedConnectionFactory supplied in options");
        }
    }

    public boolean login() throws LoginException {
        if (this.managedConnectionFactory == null) {
            return false;
        }
        Callback[] callbacks = new Callback[]{new NameCallback("User name"), new PasswordCallback("Password", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        this.resourcePrincipalName = ((NameCallback)callbacks[0]).getName();
        this.userName = ((NameCallback)callbacks[0]).getName();
        this.password = ((PasswordCallback)callbacks[1]).getPassword();
        return this.resourcePrincipalName != null && this.userName != null && this.password != null;
    }

    public boolean commit() throws LoginException {
        this.subject.getPrincipals().add(new ResourcePrincipal(this.resourcePrincipalName));
        PasswordCredential passwordCredential = new PasswordCredential(this.userName, this.password);
        passwordCredential.setManagedConnectionFactory(this.managedConnectionFactory);
        this.subject.getPrivateCredentials().add(passwordCredential);
        return true;
    }

    public boolean abort() throws LoginException {
        this.subject = null;
        this.userName = null;
        this.password = null;
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject = null;
        this.userName = null;
        this.password = null;
        return true;
    }
}

