/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.classworlds;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.codehaus.classworlds.BytesURLStreamHandler;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.Entry;
import org.codehaus.classworlds.NoSuchRealmException;
import org.codehaus.classworlds.RealmClassLoader;
import org.codehaus.classworlds.UberJarRealmClassLoader;
import org.codehaus.classworlds.UrlUtils;

class DefaultClassRealm
implements ClassRealm {
    private ClassWorld world;
    private String id;
    private Set imports;
    private RealmClassLoader classLoader;
    private ClassRealm parent;
    private ClassLoader parentClassLoader;
    List classLoaders;
    Map urlCache;
    int totalUniqueURLs;
    int totalURLs;
    int totalClassLoaders;
    int maxClassLoaders;

    DefaultClassRealm(ClassWorld world, String id, ClassLoader parentClassLoader) {
        this.world = world;
        this.id = id;
        this.parentClassLoader = parentClassLoader;
        this.imports = new TreeSet();
        this.classLoaders = new ArrayList();
        this.urlCache = new HashMap();
        this.classLoader = "true".equals(System.getProperty("classworlds.bootstrapped")) ? new UberJarRealmClassLoader(this) : new RealmClassLoader(this, parentClassLoader);
        this.totalUniqueURLs = 0;
        this.totalURLs = 0;
        this.totalClassLoaders = 1;
        this.maxClassLoaders = 1;
    }

    public ClassRealm getParent() {
        return this.parent;
    }

    public void setMaxClassLoaders(int maxClassLoaders) {
        this.maxClassLoaders = maxClassLoaders;
    }

    public void setParent(ClassRealm parent) {
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    public ClassWorld getWorld() {
        return this.world;
    }

    public void importFrom(String realmId, String pkgName) throws NoSuchRealmException {
        this.imports.add(new Entry(this.getWorld().getRealmImpl(realmId), pkgName));
    }

    public void addConstituent(URL constituent) {
        if (DefaultClassRealm.containsURL(this.classLoader, constituent)) {
            if (this.totalClassLoaders < this.maxClassLoaders) {
                this.classLoaders.add(this.classLoader);
                this.classLoader = new RealmClassLoader(this);
                this.classLoader.addConstituent(constituent);
                this.urlCache.put(constituent.toExternalForm(), constituent);
                ++this.totalClassLoaders;
                ++this.totalURLs;
            } else {
                this.urlCache.put(constituent.toExternalForm(), constituent);
                this.reload(false);
            }
        } else {
            this.classLoader.addConstituent(constituent);
            this.urlCache.put(constituent.toExternalForm(), constituent);
            ++this.totalURLs;
        }
        this.totalUniqueURLs = this.urlCache.size();
    }

    public void addConstituent(String constituent, byte[] b) throws ClassNotFoundException {
        try {
            File file;
            if (constituent.lastIndexOf(46) != -1) {
                File path = new File("byteclass/" + constituent.substring(0, constituent.lastIndexOf(46) + 1).replace('.', File.separatorChar));
                file = new File(path, constituent.substring(constituent.lastIndexOf(46) + 1) + ".class");
            } else {
                File path = new File("byteclass/");
                file = new File(path, constituent + ".class");
            }
            this.addConstituent(new URL(null, file.toURL().toExternalForm(), new BytesURLStreamHandler(b)));
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Couldn't load byte stream.", e);
        }
    }

    DefaultClassRealm locateSourceRealm(String classname) {
        Iterator entryIter = this.imports.iterator();
        while (entryIter.hasNext()) {
            Entry eachEntry = (Entry)entryIter.next();
            if (!eachEntry.matches(classname)) continue;
            return eachEntry.getRealm();
        }
        return this;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoaders.size() > 0) {
            this.reload(false);
        }
        return this.classLoader;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (name.startsWith("org.codehaus.classworlds.")) {
            return this.getWorld().loadClass(name);
        }
        DefaultClassRealm sourceRealm = this.locateSourceRealm(name);
        if (sourceRealm == this) {
            return this.loadClassDirect(name);
        }
        try {
            return sourceRealm.loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            return this.loadClassDirect(name);
        }
    }

    /*
     * Unable to fully structure code
     */
    Class loadClassDirect(String name) throws ClassNotFoundException {
        block8: {
            block9: {
                clazz = null;
                try {
                    clazz = this.classLoader.loadClassDirect(name);
                    break block8;
                }
                catch (ClassNotFoundException cnfe1) {
                    if (this.classLoaders.size() <= 0) break block9;
                    i = this.classLoaders.size() - 1;
                    ** while (i >= 0)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        clazz = ((RealmClassLoader)this.classLoaders.get(i)).loadClassDirect(name);
                        break;
                    }
                    catch (ClassNotFoundException cnfe2) {
                        --i;
                    }
                    continue;
                }
            }
            if (clazz == null) {
                if (this.getParent() != null) {
                    clazz = this.getParent().getClassLoader().loadClass(name);
                } else {
                    throw cnfe1;
                }
            }
        }
        return clazz;
    }

    public URL getResource(String name) {
        DefaultClassRealm sourceRealm = this.locateSourceRealm(name = UrlUtils.normalizeUrlPath(name));
        if (sourceRealm == this) {
            return this.loadResourceDirect(name);
        }
        return sourceRealm.getResource(name);
    }

    URL loadResourceDirect(String name) {
        URL resource;
        if (this.classLoaders.size() > 0) {
            this.reload(false);
        }
        if ((resource = this.classLoader.getResourceFromClassLoader(name)) == null && this.getParent() != null) {
            resource = this.getParent().getResource(name);
        }
        return resource;
    }

    public ClassRealm createChildRealm(String id) {
        DefaultClassRealm childRealm = new DefaultClassRealm(this.getWorld(), id, null);
        childRealm.setParent(this);
        return childRealm;
    }

    public Enumeration findResources(String name) throws IOException {
        name = UrlUtils.normalizeUrlPath(name);
        Vector resources = new Vector();
        if (this.classLoaders.size() > 0) {
            this.reload(false);
        }
        Enumeration direct = this.classLoader.findResourcesFromClassLoader(name);
        while (direct.hasMoreElements()) {
            resources.addElement(direct.nextElement());
        }
        if (this.parent != null) {
            Enumeration parent = this.getParent().getResources(name);
            while (parent.hasMoreElements()) {
                resources.addElement(parent.nextElement());
            }
        }
        return resources.elements();
    }

    public Enumeration getResources(String name) throws IOException {
        if (this.classLoaders.size() > 0) {
            this.reload(false);
        }
        return this.classLoader.getResources(name);
    }

    private static boolean containsURL(RealmClassLoader classLoader, URL url) {
        boolean contains = false;
        String srcUrlStr = url.toExternalForm();
        URL[] urls = classLoader.getURLs();
        int i = 0;
        while (i < urls.length) {
            String urlStr = urls[i].toExternalForm();
            if (srcUrlStr.equals(urlStr)) {
                contains = true;
                break;
            }
            ++i;
        }
        return contains;
    }

    public void reload() {
        this.reload(false);
    }

    public void reload(boolean reloadParent) {
        this.classLoader = new RealmClassLoader(this);
        Set keys = this.urlCache.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String urlStr = (String)it.next();
            this.classLoader.addConstituent((URL)this.urlCache.get(urlStr));
        }
        this.classLoaders.clear();
        this.totalURLs = this.totalUniqueURLs = this.urlCache.size();
        this.totalClassLoaders = 1;
        if (reloadParent && this.getParent() != null) {
            this.getParent().reload(reloadParent);
        }
    }
}

