/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.activeio.util.FactoryFinder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jdbc.JDBCAdapter;
import org.apache.servicemix.jdbc.adapter.DefaultJDBCAdapter;

public class JDBCAdapterFactory {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$servicemix$jdbc$JDBCAdapterFactory == null ? (class$org$apache$servicemix$jdbc$JDBCAdapterFactory = JDBCAdapterFactory.class$("org.apache.servicemix.jdbc.JDBCAdapterFactory")) : class$org$apache$servicemix$jdbc$JDBCAdapterFactory));
    private static FactoryFinder factoryFinder = new FactoryFinder("META-INF/services/org/apache/servicemix/jdbc/");
    static /* synthetic */ Class class$org$apache$servicemix$jdbc$JDBCAdapterFactory;

    public static JDBCAdapter getAdapter(Connection connection) {
        JDBCAdapter adapter = null;
        try {
            String driverName = connection.getMetaData().getDriverName();
            driverName = driverName.replaceAll("[^a-zA-Z0-9\\-]", "_").toLowerCase();
            try {
                adapter = (JDBCAdapter)factoryFinder.newInstance(driverName);
                log.info((Object)("Database driver recognized: [" + driverName + "]"));
            }
            catch (Throwable e) {
                log.warn((Object)("Database driver NOT recognized: [" + driverName + "].  Will use default JDBC implementation."));
            }
        }
        catch (SQLException e) {
            log.warn((Object)("JDBC error occurred while trying to detect database type.  Will use default JDBC implementation: " + e.getMessage()));
            JDBCAdapterFactory.log("Failure details: ", e);
        }
        if (adapter == null) {
            adapter = new DefaultJDBCAdapter();
        }
        return adapter;
    }

    public static void log(String msg, SQLException e) {
        if (log.isDebugEnabled() && log.isDebugEnabled()) {
            String s = msg + e.getMessage();
            while (e.getNextException() != null) {
                e = e.getNextException();
                s = s + ", due to: " + e.getMessage();
            }
            log.debug((Object)s, (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

