/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jdbc.adapter;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jdbc.JDBCAdapter;
import org.apache.servicemix.jdbc.JDBCAdapterFactory;
import org.apache.servicemix.jdbc.Statements;

public class DefaultJDBCAdapter
implements JDBCAdapter {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$servicemix$jdbc$adapter$DefaultJDBCAdapter == null ? (class$org$apache$servicemix$jdbc$adapter$DefaultJDBCAdapter = DefaultJDBCAdapter.class$("org.apache.servicemix.jdbc.adapter.DefaultJDBCAdapter")) : class$org$apache$servicemix$jdbc$adapter$DefaultJDBCAdapter));
    protected Statements statements;
    static /* synthetic */ Class class$org$apache$servicemix$jdbc$adapter$DefaultJDBCAdapter;

    protected void setBinaryData(PreparedStatement s, int index, byte[] data) throws SQLException {
        s.setBytes(index, data);
    }

    protected byte[] getBinaryData(ResultSet rs, int index) throws SQLException {
        return rs.getBytes(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doCreateTables(Connection connection) throws SQLException, IOException {
        boolean alreadyExists;
        Statement s;
        block11: {
            s = null;
            connection.setAutoCommit(false);
            alreadyExists = false;
            ResultSet rs = null;
            try {
                rs = connection.getMetaData().getTables(null, null, this.statements.getFullStoreTableName(), new String[]{"TABLE"});
                alreadyExists = rs.next();
            }
            catch (Throwable ignore) {
                DefaultJDBCAdapter.close(rs);
                catch (Throwable throwable) {
                    DefaultJDBCAdapter.close(rs);
                    throw throwable;
                }
            }
            DefaultJDBCAdapter.close(rs);
            if (!alreadyExists) break block11;
            DefaultJDBCAdapter.close(s);
            return;
        }
        try {
            s = connection.createStatement();
            String[] createStatments = this.statements.getCreateSchemaStatements();
            for (int i = 0; i < createStatments.length; ++i) {
                try {
                    log.debug((Object)("Executing SQL: " + createStatments[i]));
                    s.execute(createStatments[i]);
                    continue;
                }
                catch (SQLException e) {
                    if (alreadyExists) {
                        log.debug((Object)("Could not create JDBC tables; The message table already existed. Failure was: " + createStatments[i] + " Message: " + e.getMessage() + " SQLState: " + e.getSQLState() + " Vendor code: " + e.getErrorCode()));
                        continue;
                    }
                    log.warn((Object)("Could not create JDBC tables; they could already exist. Failure was: " + createStatments[i] + " Message: " + e.getMessage() + " SQLState: " + e.getSQLState() + " Vendor code: " + e.getErrorCode()));
                    JDBCAdapterFactory.log("Failure details: ", e);
                }
            }
            connection.commit();
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDropTables(Connection connection) throws SQLException, IOException {
        Statement s = null;
        try {
            s = connection.createStatement();
            String[] dropStatments = this.statements.getDropSchemaStatements();
            for (int i = 0; i < dropStatments.length; ++i) {
                try {
                    s.execute(dropStatments[i]);
                    continue;
                }
                catch (SQLException e) {
                    log.warn((Object)("Could not drop JDBC tables; they may not exist. Failure was: " + dropStatments[i] + " Message: " + e.getMessage() + " SQLState: " + e.getSQLState() + " Vendor code: " + e.getErrorCode()));
                    JDBCAdapterFactory.log("Failure details: ", e);
                }
            }
            connection.commit();
        }
        finally {
            DefaultJDBCAdapter.close(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStoreData(Connection connection, String id, byte[] data) throws SQLException, IOException {
        PreparedStatement s = null;
        try {
            if (s == null) {
                s = connection.prepareStatement(this.statements.getStoreDataStatement());
            }
            s.setString(1, id);
            this.setBinaryData(s, 2, data);
            if (s.executeUpdate() != 1) {
                throw new SQLException("Failed to insert data");
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] doLoadData(Connection connection, String id) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement s;
        block3: {
            byte[] byArray;
            s = null;
            rs = null;
            try {
                s = connection.prepareStatement(this.statements.getFindDataStatement());
                s.setString(1, id);
                rs = s.executeQuery();
                if (rs.next()) break block3;
                byArray = null;
            }
            catch (Throwable throwable) {
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            return byArray;
        }
        byte[] byArray = this.getBinaryData(rs, 1);
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdateData(Connection connection, String id, byte[] data) throws SQLException, IOException {
        PreparedStatement s = null;
        try {
            if (s == null) {
                s = connection.prepareStatement(this.statements.getUpdateDataStatement());
            }
            s.setString(2, id);
            this.setBinaryData(s, 1, data);
            if (s.executeUpdate() != 1) {
                throw new SQLException("Failed to update data");
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveData(Connection connection, String id) throws SQLException, IOException {
        PreparedStatement s = null;
        try {
            s = connection.prepareStatement(this.statements.getRemoveDataStatement());
            s.setString(1, id);
            if (s.executeUpdate() != 1) {
                throw new SQLException("Failed to remove data");
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
    }

    private static void close(Statement s) {
        try {
            s.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void close(ResultSet rs) {
        try {
            rs.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Statements getStatements() {
        return this.statements;
    }

    public void setStatements(Statements statements) {
        this.statements = statements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] doLoadData(Connection connection, String[] ids) throws SQLException, IOException {
        byte[][] byArrayArray;
        PreparedStatement s = null;
        byte[][] datas = new byte[ids.length][];
        try {
            s = connection.prepareStatement(this.statements.getFindDataStatement());
            for (int i = 0; i < ids.length; ++i) {
                s.setString(1, ids[i]);
                ResultSet rs = s.executeQuery();
                if (rs.next()) {
                    datas[i] = this.getBinaryData(rs, 1);
                }
                DefaultJDBCAdapter.close(rs);
            }
            byArrayArray = datas;
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
        return byArrayArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveData(Connection connection, String[] ids) throws SQLException, IOException {
        PreparedStatement s = null;
        try {
            s = connection.prepareStatement(this.statements.getRemoveDataStatement());
            for (int i = 0; i < ids.length; ++i) {
                s.setString(1, ids[i]);
                s.executeUpdate();
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doGetCount(Connection connection) throws SQLException, IOException {
        int n;
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = connection.prepareStatement(this.statements.getCountStatement());
            rs = s.executeQuery();
            rs.next();
            n = rs.getInt(1);
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] doGetIds(Connection connection) throws SQLException, IOException {
        String[] stringArray;
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            ArrayList<String> ids = new ArrayList<String>();
            s = connection.prepareStatement(this.statements.getFindAllIdsStatement());
            rs = s.executeQuery();
            while (!rs.next()) {
                ids.add(rs.getString(1));
            }
            stringArray = ids.toArray(new String[ids.size()]);
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] doGetIds(Connection connection, int fromIndex, int toIndex) throws SQLException, IOException {
        String[] stringArray;
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement(1004, 1007);
            s.setFetchSize(toIndex - fromIndex);
            rs = s.executeQuery(this.statements.getFindAllIdsStatement());
            rs.absolute(fromIndex + 1);
            String[] ids = new String[toIndex - fromIndex];
            for (int row = 0; row < toIndex - fromIndex; ++row) {
                ids[row] = rs.getString(1);
                if (!rs.next()) break;
            }
            stringArray = ids;
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return stringArray;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

