/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.kernel;

import org.apache.xbean.kernel.ServiceName;

public class InvalidServiceTypeException
extends Exception {
    private final ServiceName serviceName;
    private final Class expectedType;
    private final Class serviceType;

    public InvalidServiceTypeException(ServiceName serviceName, Class expectedType, Class serviceType) {
        super("Expected service type " + expectedType.getName() + ", but service factory created a " + serviceType.getName() + " for service " + serviceName);
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        if (expectedType == null) {
            throw new NullPointerException("expectedType is null");
        }
        if (serviceType == null) {
            throw new NullPointerException("serviceType is null");
        }
        this.serviceName = serviceName;
        this.expectedType = expectedType;
        this.serviceType = serviceType;
    }

    public ServiceName getServiceName() {
        return this.serviceName;
    }

    public Class getExpectedType() {
        return this.expectedType;
    }

    public Class getServiceType() {
        return this.serviceType;
    }
}

