/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.kernel;

import org.apache.xbean.kernel.ServiceName;

public class KernelOperationTimoutException
extends RuntimeException {
    private final ServiceName serviceName;
    private final String operationName;

    public KernelOperationTimoutException(ServiceName serviceName, String operationName) {
        super("Kernel operation timed out: serviceName=" + serviceName + ", operationName=" + operationName);
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        if (operationName == null) {
            throw new NullPointerException("operationName is null");
        }
        this.serviceName = serviceName;
        this.operationName = operationName;
    }

    public KernelOperationTimoutException(String message, ServiceName serviceName, String operationName) {
        super(message);
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        if (operationName == null) {
            throw new NullPointerException("operationName is null");
        }
        this.serviceName = serviceName;
        this.operationName = operationName;
    }

    public ServiceName getServiceName() {
        return this.serviceName;
    }

    public String getOperationName() {
        return this.operationName;
    }
}

