/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.kernel.standard;

import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.xbean.kernel.Kernel;
import org.apache.xbean.kernel.ServiceCondition;
import org.apache.xbean.kernel.ServiceFactory;
import org.apache.xbean.kernel.ServiceName;
import org.apache.xbean.kernel.standard.AggregateCondition;

public class NonRestartableStopCondition
extends AggregateCondition {
    private final ServiceFactory serviceFactory;

    public NonRestartableStopCondition(Kernel kernel, ServiceName serviceName, ClassLoader classLoader, Lock lock, ServiceFactory serviceFactory) {
        super(kernel, serviceName, classLoader, lock, Collections.EMPTY_SET);
        this.serviceFactory = serviceFactory;
    }

    public synchronized void initialize() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("initialize should never be called on a NonRestartableStopCondition");
    }

    public synchronized Set getUnsatisfied() {
        this.updateConditions();
        return super.getUnsatisfied();
    }

    private void updateConditions() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("destroyed");
        }
        Set conditions = this.getConditions();
        Set stopConditions = this.serviceFactory.getStopConditions();
        Iterator iterator = stopConditions.iterator();
        while (iterator.hasNext()) {
            ServiceCondition condition = (ServiceCondition)iterator.next();
            if (conditions.contains(condition)) continue;
            this.addCondition(condition);
        }
        iterator = conditions.iterator();
        while (iterator.hasNext()) {
            ServiceCondition serviceCondition = (ServiceCondition)iterator.next();
            if (stopConditions.contains(serviceCondition)) continue;
            this.removeCondition(serviceCondition);
        }
    }
}

