/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.kernel.standard;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.FutureTask;
import org.apache.xbean.kernel.ServiceName;
import org.apache.xbean.kernel.StopStrategy;
import org.apache.xbean.kernel.standard.ServiceManager;

class RegistryFutureTask
extends FutureTask
implements Comparable {
    private final long serviceId;
    private final ServiceName serviceName;
    private final String taskType;
    private Throwable throwable;

    static RegistryFutureTask createRegisterTask(ServiceManager serviceManager) {
        RegisterCallable registerCallable = new RegisterCallable(serviceManager);
        RegistryFutureTask registryFutureTask = new RegistryFutureTask(serviceManager.getServiceId(), serviceManager.getServiceName(), "RegisterServiceManager", registerCallable);
        return registryFutureTask;
    }

    static RegistryFutureTask createUnregisterTask(ServiceManager serviceManager, StopStrategy stopStrategy) {
        UnregisterCallable unregisterCallable = new UnregisterCallable(serviceManager, stopStrategy);
        RegistryFutureTask registryFutureTask = new RegistryFutureTask(serviceManager.getServiceId(), serviceManager.getServiceName(), "UnregisterServiceManager", unregisterCallable);
        unregisterCallable.setRegistryFutureTask(registryFutureTask);
        return registryFutureTask;
    }

    private RegistryFutureTask(long serviceId, ServiceName serviceName, String taskType, Callable callable) {
        super(callable);
        this.serviceId = serviceId;
        this.serviceName = serviceName;
        this.taskType = taskType;
    }

    public ServiceName getServiceName() {
        return this.serviceName;
    }

    public synchronized Throwable getThrowable() {
        return this.throwable;
    }

    private synchronized void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public int hashCode() {
        return (int)(this.serviceId ^ this.serviceId >>> 32);
    }

    public boolean equals(Object o) {
        if (o instanceof RegistryFutureTask) {
            return this.serviceId == ((RegistryFutureTask)o).serviceId;
        }
        return false;
    }

    public int compareTo(Object o) {
        RegistryFutureTask registryFutureTask = (RegistryFutureTask)o;
        if (this.serviceId < registryFutureTask.serviceId) {
            return -1;
        }
        if (this.serviceId > registryFutureTask.serviceId) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "[RegistryFutureTask: task=" + this.taskType + ", serviceName=" + this.serviceName + "]";
    }

    private static class UnregisterCallable
    implements Callable {
        private final ServiceManager serviceManager;
        private final StopStrategy stopStrategy;
        private RegistryFutureTask registryFutureTask;

        private UnregisterCallable(ServiceManager serviceManager, StopStrategy stopStrategy) {
            this.serviceManager = serviceManager;
            this.stopStrategy = stopStrategy;
        }

        public void setRegistryFutureTask(RegistryFutureTask registryFutureTask) {
            this.registryFutureTask = registryFutureTask;
        }

        public Object call() {
            try {
                this.serviceManager.destroy(this.stopStrategy);
                return null;
            }
            catch (Throwable e) {
                this.registryFutureTask.setThrowable(e);
                return this.serviceManager;
            }
        }
    }

    private static class RegisterCallable
    implements Callable {
        private final ServiceManager serviceManager;

        private RegisterCallable(ServiceManager serviceManager) {
            this.serviceManager = serviceManager;
        }

        public Object call() throws Exception {
            this.serviceManager.initialize();
            return this.serviceManager;
        }
    }
}

