/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.scope;

import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.scope.DefaultScopedObject;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.aop.target.PrototypeTargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;

public class ScopedProxyFactoryBean
extends ProxyConfig
implements FactoryBean,
BeanFactoryAware {
    private final PrototypeTargetSource scopedTargetSource = new PrototypeTargetSource();
    private Object proxy;

    public ScopedProxyFactoryBean() {
        this.setProxyTargetClass(true);
    }

    public void setTargetBeanName(String targetBeanName) {
        this.scopedTargetSource.setTargetBeanName(targetBeanName);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof ConfigurableBeanFactory)) {
            throw new IllegalStateException("Not running in a ConfigurableBeanFactory: " + beanFactory);
        }
        ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)beanFactory;
        this.scopedTargetSource.setBeanFactory(beanFactory);
        ProxyFactory pf = new ProxyFactory();
        pf.copyFrom(this);
        pf.setTargetSource(this.scopedTargetSource);
        DefaultScopedObject scopedObject = new DefaultScopedObject(cbf, this.scopedTargetSource.getTargetBeanName());
        pf.addAdvice(new DelegatingIntroductionInterceptor(scopedObject));
        this.proxy = pf.getProxy();
    }

    public Object getObject() {
        return this.proxy;
    }

    public Class getObjectType() {
        if (this.proxy != null) {
            return this.proxy.getClass();
        }
        if (this.scopedTargetSource != null) {
            return this.scopedTargetSource.getTargetClass();
        }
        return null;
    }

    public boolean isSingleton() {
        return true;
    }
}

