/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class PropertyPathBeanDefinitionParser
implements BeanDefinitionParser {
    static /* synthetic */ Class class$org$springframework$beans$factory$config$PropertyPathFactoryBean;

    PropertyPathBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String id = element.getAttribute("id");
        String path = element.getAttribute("path");
        Assert.hasText(path, "Attribute 'path' must not be null or zero length.");
        int dotIndex = path.indexOf(".");
        if (dotIndex == -1) {
            throw new IllegalArgumentException("Attribute 'path' must follow pattern 'beanName.propertyName'.");
        }
        String beanName = path.substring(0, dotIndex);
        String propertyPath = path.substring(dotIndex + 1);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(class$org$springframework$beans$factory$config$PropertyPathFactoryBean == null ? (class$org$springframework$beans$factory$config$PropertyPathFactoryBean = PropertyPathBeanDefinitionParser.class$("org.springframework.beans.factory.config.PropertyPathFactoryBean")) : class$org$springframework$beans$factory$config$PropertyPathFactoryBean);
        builder.addPropertyValue("targetBeanName", beanName);
        builder.addPropertyValue("propertyPath", propertyPath);
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        id = StringUtils.hasText(id) ? id : BeanDefinitionReaderUtils.generateBeanName(definition, parserContext.getRegistry(), false);
        parserContext.getRegistry().registerBeanDefinition(id, builder.getBeanDefinition());
        return definition;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

