/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;

public abstract class GenericCollectionTypeResolver {
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;

    public static Class getCollectionParameterType(MethodParameter methodParam) {
        return GenericCollectionTypeResolver.getGenericParameterType(methodParam, class$java$util$Collection == null ? (class$java$util$Collection = GenericCollectionTypeResolver.class$("java.util.Collection")) : class$java$util$Collection, 0);
    }

    public static Class getMapKeyParameterType(MethodParameter methodParam) {
        return GenericCollectionTypeResolver.getGenericParameterType(methodParam, class$java$util$Map == null ? (class$java$util$Map = GenericCollectionTypeResolver.class$("java.util.Map")) : class$java$util$Map, 0);
    }

    public static Class getMapValueParameterType(MethodParameter methodParam) {
        return GenericCollectionTypeResolver.getGenericParameterType(methodParam, class$java$util$Map == null ? (class$java$util$Map = GenericCollectionTypeResolver.class$("java.util.Map")) : class$java$util$Map, 1);
    }

    public static Class getCollectionReturnType(Method method) {
        return GenericCollectionTypeResolver.getGenericReturnType(method, class$java$util$Collection == null ? (class$java$util$Collection = GenericCollectionTypeResolver.class$("java.util.Collection")) : class$java$util$Collection, 0);
    }

    public static Class getMapKeyReturnType(Method method) {
        return GenericCollectionTypeResolver.getGenericReturnType(method, class$java$util$Map == null ? (class$java$util$Map = GenericCollectionTypeResolver.class$("java.util.Map")) : class$java$util$Map, 0);
    }

    public static Class getMapValueReturnType(Method method) {
        return GenericCollectionTypeResolver.getGenericReturnType(method, class$java$util$Map == null ? (class$java$util$Map = GenericCollectionTypeResolver.class$("java.util.Map")) : class$java$util$Map, 1);
    }

    private static Class getGenericParameterType(MethodParameter methodParam, Class source, int typeIndex) {
        Assert.notNull(methodParam, "MethodParameter must not be null");
        int idx = methodParam.getParameterIndex();
        if (methodParam.getConstructor() != null) {
            return GenericCollectionTypeResolver.extractType(methodParam.getConstructor().getGenericParameterTypes()[idx], source, typeIndex);
        }
        return GenericCollectionTypeResolver.extractType(methodParam.getMethod().getGenericParameterTypes()[idx], source, typeIndex);
    }

    private static Class getGenericReturnType(Method method, Class source, int typeIndex) {
        Assert.notNull(method, "Method must not be null");
        return GenericCollectionTypeResolver.extractType(method.getGenericReturnType(), source, typeIndex);
    }

    private static Class extractType(Type type, Class source, int typeIndex) {
        if (type instanceof ParameterizedType) {
            return GenericCollectionTypeResolver.extractTypeFromParameterizedType((ParameterizedType)type, source, typeIndex);
        }
        if (type instanceof Class) {
            return GenericCollectionTypeResolver.extractTypeFromClass((Class)type, source, typeIndex);
        }
        return null;
    }

    private static Class extractTypeFromParameterizedType(ParameterizedType ptype, Class source, int typeIndex) {
        Type[] lowerBounds;
        if (!(ptype.getRawType() instanceof Class)) {
            return null;
        }
        Class rawType = (Class)ptype.getRawType();
        if (!source.isAssignableFrom(rawType)) {
            return null;
        }
        Class fromSuperclassOrInterface = GenericCollectionTypeResolver.extractType(rawType, source, typeIndex);
        if (fromSuperclassOrInterface != null) {
            return fromSuperclassOrInterface;
        }
        Type[] paramTypes = ptype.getActualTypeArguments();
        if (paramTypes == null || typeIndex >= paramTypes.length) {
            return null;
        }
        Type paramType = paramTypes[typeIndex];
        if (paramType instanceof WildcardType && (lowerBounds = ((WildcardType)paramType).getLowerBounds()) != null && lowerBounds.length > 0) {
            paramType = lowerBounds[0];
        }
        if (paramType instanceof ParameterizedType) {
            paramType = ((ParameterizedType)paramType).getRawType();
        }
        if (paramType instanceof Class) {
            return (Class)paramType;
        }
        return null;
    }

    private static Class extractTypeFromClass(Class clazz, Class source, int typeIndex) {
        if (clazz.getSuperclass() != null && source.isAssignableFrom(clazz.getSuperclass())) {
            return GenericCollectionTypeResolver.extractType(clazz.getGenericSuperclass(), source, typeIndex);
        }
        Type[] ifcs = clazz.getGenericInterfaces();
        if (ifcs != null) {
            for (int i = 0; i < ifcs.length; ++i) {
                Type ifc;
                Type rawType = ifc = ifcs[i];
                if (ifc instanceof ParameterizedType) {
                    rawType = ((ParameterizedType)ifc).getRawType();
                }
                if (!(rawType instanceof Class) || !source.isAssignableFrom((Class)rawType)) continue;
                return GenericCollectionTypeResolver.extractType(ifc, source, typeIndex);
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

