/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading;

import java.lang.instrument.ClassFileTransformer;
import org.springframework.instrument.ClassFileTransformerRegistry;
import org.springframework.instrument.classloading.AbstractOverridingClassLoader;
import org.springframework.instrument.classloading.AspectJWeavingTransformer;
import org.springframework.util.ClassUtils;

public class SimpleInstrumentableClassLoader
extends AbstractOverridingClassLoader
implements ClassFileTransformerRegistry {
    private final AspectJWeavingTransformer weavingTransformer;

    public SimpleInstrumentableClassLoader(ClassLoader parent) {
        super(parent);
        this.weavingTransformer = new AspectJWeavingTransformer(parent);
    }

    public SimpleInstrumentableClassLoader() {
        super(ClassUtils.getDefaultClassLoader());
        this.weavingTransformer = new AspectJWeavingTransformer(this.getParent());
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.weavingTransformer.addTransformer(transformer);
    }

    public byte[] transformIfNecessary(String name, String internalName, byte[] bytes) {
        return this.weavingTransformer.transformIfNecessary(name, bytes, null);
    }
}

