/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.instrument.ClassFileTransformerRegistry;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class WeavingTransformer
implements ClassFileTransformerRegistry {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final boolean debug = this.logger.isDebugEnabled();
    private final ClassLoader classLoader;
    private List<ClassFileTransformer> transformers = new ArrayList<ClassFileTransformer>();

    public WeavingTransformer() {
        this.classLoader = ClassUtils.getDefaultClassLoader();
    }

    public WeavingTransformer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void addTransformer(ClassFileTransformer transformer) {
        if (this.debug) {
            this.logger.debug((Object)("Adding transformer: " + transformer));
        }
        this.transformers.add(transformer);
    }

    public byte[] transformIfNecessary(String name, String internalName, byte[] bytes, ProtectionDomain pd) {
        for (ClassFileTransformer cft : this.transformers) {
            try {
                byte[] transformed = cft.transform(this.classLoader, internalName, null, pd, bytes);
                if (transformed == null) {
                    if (!this.debug) continue;
                    this.logger.debug((Object)("Not weaving class [" + name + "] with transformer [" + cft + "]"));
                    continue;
                }
                if (this.debug) {
                    this.logger.debug((Object)("Weaving [" + name + "] with transformer [" + cft + "]"));
                }
                bytes = transformed;
            }
            catch (IllegalClassFormatException ex) {
                throw new IllegalStateException("Cannot transform class [" + name + "] with transformer [" + cft + "]", ex);
            }
        }
        return bytes;
    }

    public byte[] transformIfNecessary(String className, byte[] bytes, ProtectionDomain pd) {
        String internalName = StringUtils.replace(className, ".", "/");
        return this.transformIfNecessary(className, internalName, bytes, pd);
    }
}

