/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerPlus;
import org.springframework.orm.jpa.JpaDialect;

public abstract class SharedEntityManagerCreator {
    public static EntityManager createSharedEntityManager(EntityManagerFactory emf) {
        Class[] entityManagerInterfaces = null;
        if (emf instanceof EntityManagerFactoryInfo) {
            EntityManagerFactoryInfo emfInfo = (EntityManagerFactoryInfo)emf;
            Class entityManagerInterface = emfInfo.getEntityManagerInterface();
            JpaDialect jpaDialect = emfInfo.getJpaDialect();
            entityManagerInterfaces = jpaDialect != null && jpaDialect.supportsEntityManagerPlusOperations() ? new Class[]{entityManagerInterface, EntityManagerPlus.class} : new Class[]{entityManagerInterface};
        } else {
            entityManagerInterfaces = new Class[]{EntityManager.class};
        }
        return SharedEntityManagerCreator.createSharedEntityManager(emf, entityManagerInterfaces);
    }

    public static EntityManager createSharedEntityManager(EntityManagerFactory emf, Class ... entityManagerInterfaces) {
        return (EntityManager)Proxy.newProxyInstance(SharedEntityManagerCreator.class.getClassLoader(), entityManagerInterfaces, (InvocationHandler)new SharedEntityManagerInvocationHandler(emf));
    }

    private static class SharedEntityManagerInvocationHandler
    implements InvocationHandler {
        private final Log logger = LogFactory.getLog(this.getClass());
        private final EntityManagerFactory targetFactory;

        public SharedEntityManagerInvocationHandler(EntityManagerFactory target) {
            this.targetFactory = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("isOpen")) {
                return true;
            }
            if (method.getName().equals("close")) {
                return null;
            }
            if (method.getName().equals("getTransaction")) {
                throw new IllegalStateException("Not allowed to create transaction on shared EntityManager - use Spring transactions or EJB CMT instead");
            }
            if (method.getName().equals("joinTransaction")) {
                throw new IllegalStateException("Not allowed to join transaction on shared EntityManager - use Spring transactions or EJB CMT instead");
            }
            EntityManager target = EntityManagerFactoryUtils.doGetTransactionalEntityManager(this.targetFactory);
            boolean isNewEm = false;
            if (target == null) {
                this.logger.debug((Object)"Creating new EntityManager for shared EntityManager invocation");
                target = this.targetFactory.createEntityManager();
                isNewEm = true;
            }
            try {
                Object object = method.invoke((Object)target, args);
                return object;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
            finally {
                if (isNewEm) {
                    target.close();
                }
            }
        }
    }
}

