/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.portlet.handler.AbstractHandlerMapping;

public class PortletModeParameterHandlerMapping
extends AbstractHandlerMapping {
    public static final String DEFAULT_PARAMETER_NAME = "action";
    private String parameterName = "action";
    private Map portletModeParameterMap;
    private boolean lazyInitHandlers = false;
    protected final Map handlerMap = new HashMap();
    private boolean allowDupParameters = false;
    private Map parameterUsedMap = new HashMap();

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setPortletModeParameterMap(Map portletModeParameterMap) {
        this.portletModeParameterMap = portletModeParameterMap;
    }

    public void setLazyInitHandlers(boolean lazyInitHandlers) {
        this.lazyInitHandlers = lazyInitHandlers;
    }

    public void setAllowDupParameters(boolean allowDupParameters) {
        this.allowDupParameters = allowDupParameters;
    }

    public void initApplicationContext() throws BeansException {
        if (this.parameterName == null) {
            throw new IllegalArgumentException("A parameterName is required");
        }
        if (this.portletModeParameterMap == null || this.portletModeParameterMap.isEmpty()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"'portletModeParameterMap' not set on PortletModeParameterHandlerMapping");
            }
        } else {
            Iterator it = this.portletModeParameterMap.keySet().iterator();
            while (it.hasNext()) {
                String modeKey = (String)it.next();
                PortletMode mode = new PortletMode(modeKey);
                Object parameterMapObj = this.portletModeParameterMap.get(modeKey);
                if (parameterMapObj != null && !(parameterMapObj instanceof Map)) {
                    throw new IllegalArgumentException("The value for the portlet mode must be a Map of parameters to handlers");
                }
                Map parameterMap = (Map)parameterMapObj;
                Iterator it2 = parameterMap.keySet().iterator();
                while (it2.hasNext()) {
                    String parameter = (String)it2.next();
                    Object handler = parameterMap.get(parameter);
                    this.registerHandler(mode, parameter, handler);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void registerHandler(PortletMode mode, String parameter, Object handler) throws BeansException {
        Object mappedHandler;
        HashMap<String, Object> parameterMap = (HashMap<String, Object>)this.handlerMap.get(mode);
        if (parameterMap == null) {
            parameterMap = new HashMap<String, Object>();
            this.handlerMap.put(mode, parameterMap);
        }
        if ((mappedHandler = parameterMap.get(parameter)) != null) {
            throw new ApplicationContextException("Cannot map handler [" + handler + "] to parameter [" + parameter + "] in mode [" + mode + "]: there's already handler [" + mappedHandler + "] mapped");
        }
        if (this.parameterUsedMap.get(parameter) != null) {
            if (!this.allowDupParameters) throw new ApplicationContextException("Duplicate entries for parameter [" + parameter + "] in different modes");
            this.logger.info((Object)("Duplicate entries for parameter [" + parameter + "] in different modes"));
        } else {
            this.parameterUsedMap.put(parameter, Boolean.TRUE);
        }
        if (!this.lazyInitHandlers && handler instanceof String) {
            String handlerName = (String)handler;
            if (this.getApplicationContext().isSingleton(handlerName)) {
                handler = this.getApplicationContext().getBean(handlerName);
            }
        }
        parameterMap.put(parameter, handler);
        if (!this.logger.isDebugEnabled()) return;
        this.logger.debug((Object)("Mapped mode [" + mode + "] parameter [" + parameter + "] onto handler [" + handler + "]"));
    }

    protected Object getHandlerInternal(PortletRequest request) throws Exception {
        PortletMode mode = request.getPortletMode();
        Map parameterMap = (Map)this.handlerMap.get(mode);
        if (parameterMap == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No handler map present for mode [" + mode + "]"));
            }
            return null;
        }
        String parameter = request.getParameter(this.getParameterName());
        Object handler = parameterMap.get(parameter);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Portlet mode '" + mode + "', parameter [" + parameter + "] -> " + "handler [" + handler + "]"));
        }
        return handler;
    }
}

