/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.context.v2;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import org.apache.xbean.spring.context.impl.PropertyEditorHelper;
import org.apache.xbean.spring.context.impl.QNameReflectionHelper;
import org.apache.xbean.spring.context.v2.XBeanQNameHelper;
import org.springframework.beans.factory.ParseState;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XBeanBeanDefinitionParserDelegate
extends BeanDefinitionParserDelegate {
    public static final String QNAME_ELEMENT = "qname";
    private XBeanQNameHelper qnameHelper;

    public XBeanBeanDefinitionParserDelegate(XmlReaderContext readerContext) {
        super(readerContext);
        this.qnameHelper = new XBeanQNameHelper(readerContext);
    }

    public Object parsePropertySubElement(Element ele, String defaultTypeClassName) {
        if (!this.isDefaultNamespace(ele.getNamespaceURI())) {
            return this.parseNestedCustomElement(ele);
        }
        if (ele.getTagName().equals(QNAME_ELEMENT)) {
            return this.parseQNameElement(ele);
        }
        return super.parsePropertySubElement(ele, defaultTypeClassName);
    }

    public BeanDefinition parseBeanDefinitionElement(Element ele, String beanName) {
        BeanDefinition bd = super.parseBeanDefinitionElement(ele, beanName);
        this.qnameHelper.coerceNamespaceAwarePropertyValues(bd, ele);
        return bd;
    }

    public boolean isDefaultNamespace(String namespaceUri) {
        return !StringUtils.hasLength((String)namespaceUri) || "http://www.springframework.org/schema/beans".equals(namespaceUri) || "http://xbean.apache.org/schemas/spring/1.0".equals(namespaceUri) || "http://xbean.org/schemas/spring/1.0".equals(namespaceUri);
    }

    protected Object parseQNameElement(Element element) {
        return QNameReflectionHelper.createQName(element, this.getElementText(element));
    }

    protected String getElementText(Element element) {
        StringBuffer buffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            buffer.append(node.getNodeValue());
        }
        return buffer.toString();
    }

    private Object parseNestedCustomElement(Element candidateEle) {
        BeanDefinition innerDefinition = this.parseCustomElement(candidateEle, true);
        if (innerDefinition == null) {
            this.error("Incorrect usage of element '" + candidateEle.getNodeName() + "' in a nested manner. This tag cannot be used nested inside <property>.", candidateEle);
            return null;
        }
        return innerDefinition;
    }

    private void error(String message, Object source) {
        ParseState parseState = null;
        try {
            Field f = ((Object)((Object)this)).getClass().getField("parseState");
            ((AccessibleObject)f).setAccessible(true);
            ParseState ps = (ParseState)f.get((Object)this);
            parseState = ps.snapshot();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.getReaderContext().error(message, source, parseState);
    }

    static {
        PropertyEditorHelper.registerCustomEditors();
    }
}

