/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import java.util.Iterator;
import java.util.Set;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.apache.servicemix.components.util.TransformComponentSupport;
import org.apache.servicemix.jbi.FaultException;

public class ChainedComponent
extends TransformComponentSupport {
    private QName[] services = new QName[0];

    protected boolean transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        NormalizedMessage curIn = in;
        MessageExchange curExchange = exchange;
        for (int i = 0; i < this.services.length; ++i) {
            InOut mexchange = this.getDeliveryChannel().createExchangeFactoryForService(this.services[i]).createInOutExchange();
            this.copyProperties(curExchange, (MessageExchange)mexchange);
            curIn = this.invokeService(mexchange, curIn, this.services[i]);
            curExchange = mexchange;
        }
        this.getMessageTransformer().transform(exchange, curIn, out);
        this.copyProperties(curExchange, exchange);
        return true;
    }

    private NormalizedMessage invokeService(InOut exchange, NormalizedMessage in, QName service) throws MessagingException {
        NormalizedMessage msg = exchange.createMessage();
        this.getMessageTransformer().transform((MessageExchange)exchange, in, msg);
        exchange.setMessage(msg, "in");
        boolean result = this.getDeliveryChannel().sendSync((MessageExchange)exchange);
        if (result) {
            if (exchange.getStatus() == ExchangeStatus.ERROR) {
                exchange.setStatus(ExchangeStatus.DONE);
                this.getDeliveryChannel().send((MessageExchange)exchange);
                if (exchange.getError() != null) {
                    throw new MessagingException("Received error", (Throwable)exchange.getError());
                }
                if (exchange.getFault() != null) {
                    throw new FaultException("Received fault", (MessageExchange)exchange, exchange.getFault());
                }
                throw new MessagingException("Received unknown error");
            }
            NormalizedMessage out = exchange.getOutMessage();
            exchange.setStatus(ExchangeStatus.DONE);
            this.getDeliveryChannel().send((MessageExchange)exchange);
            return out;
        }
        throw new MessagingException("Could not invoke service: " + service);
    }

    private void copyProperties(MessageExchange in, MessageExchange out) {
        Set propertyNames = in.getPropertyNames();
        Iterator iter = propertyNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            out.setProperty(name, in.getProperty(name));
        }
    }

    public void setServices(QName[] services) {
        this.services = services;
    }
}

