/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.components.util.ComponentSupport;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;

public class TraceComponent
extends ComponentSupport
implements MessageExchangeListener {
    private Log log = LogFactory.getLog((Class)TraceComponent.class);
    private SourceTransformer sourceTransformer = new SourceTransformer();

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public SourceTransformer getSourceTransformer() {
        return this.sourceTransformer;
    }

    public void setSourceTransformer(SourceTransformer sourceTransformer) {
        this.sourceTransformer = sourceTransformer;
    }

    public void onMessageExchange(MessageExchange exchange) throws MessagingException {
        NormalizedMessage message = exchange.getMessage("in");
        if (message == null) {
            this.log.warn((Object)("Received null message from exchange: " + exchange));
        } else {
            this.log.info((Object)("Exchange: " + exchange + " received IN message: " + message));
            try {
                this.log.info((Object)("Body is: " + this.sourceTransformer.toString(message.getContent())));
            }
            catch (TransformerException e) {
                this.log.error((Object)("Failed to turn message body into text: " + e), (Throwable)e);
            }
        }
        this.done(exchange);
    }
}

