/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.audit;

import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.audit.AuditorException;
import org.apache.servicemix.jbi.audit.AuditorMBean;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.event.ExchangeListener;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.BaseSystemService;
import org.apache.servicemix.jbi.management.OperationInfoHelper;
import org.apache.servicemix.jbi.management.ParameterHelper;

public abstract class AbstractAuditor
extends BaseSystemService
implements AuditorMBean,
ExchangeListener {
    protected final Log log = LogFactory.getLog(this.getClass());
    private boolean asContainerListener = true;

    public JBIContainer getContainer() {
        return this.container;
    }

    public void setContainer(JBIContainer container) {
        this.container = container;
    }

    protected Class getServiceMBean() {
        return AuditorMBean.class;
    }

    public void start() throws JBIException {
        super.start();
        this.doStart();
        if (this.isAsContainerListener()) {
            this.container.addListener(this);
        }
    }

    public void stop() throws JBIException {
        this.container.removeListener(this);
        this.doStop();
        super.stop();
    }

    protected void doStart() throws JBIException {
    }

    protected void doStop() throws JBIException {
    }

    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "exchangeCount", "number of exchanges");
        return AttributeInfoHelper.join(super.getAttributeInfos(), helper.getAttributeInfos());
    }

    public MBeanOperationInfo[] getOperationInfos() throws JMException {
        OperationInfoHelper helper = new OperationInfoHelper();
        ParameterHelper ph = helper.addOperation(this.getObjectToManage(), "getExchanges", 2, "retrieve a bunch messages");
        ph.setDescription(0, "fromIndex", "lower index of message (start from 0)");
        ph.setDescription(1, "toIndex", "upper index of message (exclusive, > fromIndex)");
        return OperationInfoHelper.join(super.getOperationInfos(), helper.getOperationInfos());
    }

    public abstract int getExchangeCount() throws AuditorException;

    public String getExchangeId(int index) throws AuditorException {
        if (index < 0) {
            throw new IllegalArgumentException("index should be greater or equal to zero");
        }
        return this.getExchangeIds(index, index + 1)[0];
    }

    public String[] getExchangeIds() throws AuditorException {
        return this.getExchangeIds(0, this.getExchangeCount());
    }

    public abstract String[] getExchangeIds(int var1, int var2) throws AuditorException;

    public MessageExchange getExchange(int index) throws AuditorException {
        if (index < 0) {
            throw new IllegalArgumentException("index should be greater or equal to zero");
        }
        return this.getExchanges(index, index + 1)[0];
    }

    public MessageExchange getExchange(String id) throws AuditorException {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("id should be non null and non empty");
        }
        return this.getExchanges(new String[]{id})[0];
    }

    public MessageExchange[] getExchanges() throws AuditorException {
        return this.getExchanges(0, this.getExchangeCount());
    }

    public MessageExchange[] getExchanges(int fromIndex, int toIndex) throws AuditorException {
        return this.getExchanges(this.getExchangeIds(fromIndex, toIndex));
    }

    public abstract MessageExchange[] getExchanges(String[] var1) throws AuditorException;

    public int deleteExchanges() throws AuditorException {
        return this.deleteExchanges(0, this.getExchangeCount());
    }

    public boolean deleteExchange(int index) throws AuditorException {
        if (index < 0) {
            throw new IllegalArgumentException("index should be greater or equal to zero");
        }
        return this.deleteExchanges(index, index + 1) == 1;
    }

    public boolean deleteExchange(String id) throws AuditorException {
        return this.deleteExchanges(new String[]{id}) == 1;
    }

    public int deleteExchanges(int fromIndex, int toIndex) throws AuditorException {
        return this.deleteExchanges(this.getExchangeIds(fromIndex, toIndex));
    }

    public abstract int deleteExchanges(String[] var1) throws AuditorException;

    public void resendExchange(MessageExchange exchange) throws JBIException {
        this.container.resendExchange(exchange);
    }

    public boolean isAsContainerListener() {
        return this.asContainerListener;
    }

    public void setAsContainerListener(boolean addToContainer) {
        this.asContainerListener = addToContainer;
    }
}

