/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.audit.jdbc;

import java.io.IOException;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import javax.jbi.messaging.MessageExchange;
import javax.sql.DataSource;
import org.apache.servicemix.jbi.audit.AbstractAuditor;
import org.apache.servicemix.jbi.audit.AuditorException;
import org.apache.servicemix.jbi.event.ExchangeEvent;
import org.apache.servicemix.jbi.messaging.ExchangePacket;
import org.apache.servicemix.jbi.messaging.InOnlyImpl;
import org.apache.servicemix.jbi.messaging.InOptionalOutImpl;
import org.apache.servicemix.jbi.messaging.InOutImpl;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.messaging.MessageExchangeSupport;
import org.apache.servicemix.jbi.messaging.RobustInOnlyImpl;
import org.apache.servicemix.jdbc.JDBCAdapter;
import org.apache.servicemix.jdbc.JDBCAdapterFactory;
import org.apache.servicemix.jdbc.Statements;
import org.springframework.beans.factory.InitializingBean;

public class JdbcAuditor
extends AbstractAuditor
implements InitializingBean {
    private DataSource dataSource;
    private boolean autoStart = true;
    private Statements statements;
    private String tableName = "SM_AUDIT";
    private JDBCAdapter adapter;
    private boolean createDataBase = true;

    public String getDescription() {
        return "JDBC Auditing Service";
    }

    public void afterPropertiesSet() throws Exception {
        if (this.container == null) {
            throw new IllegalArgumentException("container should not be null");
        }
        if (this.dataSource == null) {
            throw new IllegalArgumentException("dataSource should not be null");
        }
        if (this.statements == null) {
            this.statements = new Statements();
            this.statements.setStoreTableName(this.tableName);
        }
        Connection connection = null;
        try {
            connection = this.getDataSource().getConnection();
            this.adapter = JDBCAdapterFactory.getAdapter((Connection)connection);
            if (this.statements == null) {
                this.statements = new Statements();
                this.statements.setStoreTableName(this.tableName);
            }
            this.adapter.setStatements(this.statements);
            if (this.createDataBase) {
                this.adapter.doCreateTables(connection);
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw (IOException)new IOException("Exception while creating database").initCause(e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        this.init(this.getContainer());
        if (this.autoStart) {
            this.start();
        } else {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exchangeSent(ExchangeEvent event) {
        MessageExchange exchange = event.getExchange();
        if (!(exchange instanceof MessageExchangeImpl)) {
            throw new IllegalArgumentException("exchange should be a MessageExchangeImpl");
        }
        try {
            ExchangePacket packet = ((MessageExchangeImpl)exchange).getPacket();
            String id = packet.getExchangeId();
            byte[] data = packet.getData();
            Connection connection = this.dataSource.getConnection();
            try {
                this.store(connection, id, data);
                connection.commit();
            }
            finally {
                JdbcAuditor.close(connection);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Could not persist exchange", (Throwable)e);
        }
    }

    private static void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void store(Connection connection, String id, byte[] data) throws Exception {
        if (this.adapter.doLoadData(connection, id) != null) {
            this.adapter.doUpdateData(connection, id, data);
        } else {
            this.adapter.doStoreData(connection, id, data);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public int getExchangeCount() throws AuditorException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            int n = this.adapter.doGetCount(connection);
            return n;
        }
        catch (Exception e) {
            throw new AuditorException("Could not retrieve exchange count", e);
        }
        finally {
            JdbcAuditor.close(connection);
        }
    }

    public String[] getExchangeIds(int fromIndex, int toIndex) throws AuditorException {
        if (fromIndex < 0) {
            throw new IllegalArgumentException("fromIndex should be greater or equal to zero");
        }
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException("toIndex should be greater or equal to fromIndex");
        }
        if (fromIndex == toIndex) {
            return new String[0];
        }
        Connection connection = null;
        try {
            String[] ids;
            connection = this.dataSource.getConnection();
            String[] stringArray = ids = this.adapter.doGetIds(connection, fromIndex, toIndex);
            return stringArray;
        }
        catch (Exception e) {
            throw new AuditorException("Could not retrieve exchange ids", e);
        }
        finally {
            JdbcAuditor.close(connection);
        }
    }

    public MessageExchange[] getExchanges(String[] ids) throws AuditorException {
        MessageExchange[] exchanges = new MessageExchange[ids.length];
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            for (int row = 0; row < ids.length; ++row) {
                exchanges[row] = this.getExchange(this.adapter.doLoadData(connection, ids[row]));
            }
            MessageExchange[] row = exchanges;
            return row;
        }
        catch (Exception e) {
            throw new AuditorException("Could not retrieve exchanges", e);
        }
        finally {
            JdbcAuditor.close(connection);
        }
    }

    public int deleteExchanges(String[] ids) throws AuditorException {
        Connection connection = null;
        try {
            int row;
            connection = this.dataSource.getConnection();
            for (row = 0; row < ids.length; ++row) {
                this.adapter.doRemoveData(connection, ids[row]);
            }
            row = -1;
            return row;
        }
        catch (Exception e) {
            throw new AuditorException("Could not delete exchanges", e);
        }
        finally {
            JdbcAuditor.close(connection);
        }
    }

    protected MessageExchange getExchange(byte[] data) throws AuditorException {
        ExchangePacket packet = null;
        try {
            packet = ExchangePacket.readPacket(data);
        }
        catch (Exception e) {
            throw new AuditorException("Unable to reconstruct exchange", e);
        }
        URI mep = packet.getPattern();
        if (MessageExchangeSupport.IN_ONLY.equals(mep)) {
            return new InOnlyImpl(packet);
        }
        if (MessageExchangeSupport.IN_OPTIONAL_OUT.equals(mep)) {
            return new InOptionalOutImpl(packet);
        }
        if (MessageExchangeSupport.IN_OUT.equals(mep)) {
            return new InOutImpl(packet);
        }
        if (MessageExchangeSupport.ROBUST_IN_ONLY.equals(mep)) {
            return new RobustInOnlyImpl(packet);
        }
        throw new AuditorException("Unhandled mep: " + mep);
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }
}

