/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.config.spring.ElementProcessor;
import org.apache.servicemix.jbi.config.spring.QNameElementProcessor;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComponentElementProcessor
extends QNameElementProcessor
implements ElementProcessor {
    private static final transient Log log = LogFactory.getLog((Class)ComponentElementProcessor.class);

    public void processElement(Element element, BeanDefinitionReader beanDefinitionReader) {
        String persistent;
        String failOnNoEndpoint;
        String destinationOperation;
        String destinationInterface;
        String destinationService;
        String destinationEndpoint;
        String endpoint;
        String operation;
        String interfaceName;
        Document document = element.getOwnerDocument();
        Element root = (Element)element.getParentNode();
        String id = element.getAttribute("id");
        if (id == null || id.length() == 0) {
            throw new BeanDefinitionStoreException("A <component> must have an id attribute");
        }
        Element registration = this.addBeanElement(root, "org.apache.servicemix.jbi.container.ActivationSpec");
        this.addPropertyElement(registration, "id", id);
        Element componentProperty = this.addPropertyElement(registration, "component");
        Element bean = document.createElement("bean");
        componentProperty.appendChild(bean);
        String service = element.getAttribute("service");
        if (service != null) {
            element.removeAttribute("service");
            this.addQNameProperty(registration, "service", service, element);
        }
        if ((interfaceName = element.getAttribute("interface")) != null) {
            element.removeAttribute("interface");
            this.addQNameProperty(registration, "interfaceName", interfaceName, element);
        }
        if ((operation = element.getAttribute("operation")) != null) {
            element.removeAttribute("operation");
            this.addQNameProperty(registration, "operation", operation, element);
        }
        if ((endpoint = element.getAttribute("endpoint")) != null) {
            element.removeAttribute("endpoint");
            if (endpoint.length() > 0) {
                this.addPropertyElement(registration, "endpoint", endpoint);
            }
        }
        if ((destinationEndpoint = element.getAttribute("destinationEndpoint")) != null) {
            element.removeAttribute("destinationEndpoint");
            if (destinationEndpoint.length() > 0) {
                this.addPropertyElement(registration, "destinationEndpoint", destinationEndpoint);
            }
        }
        if ((destinationService = element.getAttribute("destinationService")) != null) {
            element.removeAttribute("destinationService");
            this.addQNameProperty(registration, "destinationService", destinationService, element);
        }
        if ((destinationInterface = element.getAttribute("destinationInterface")) != null) {
            element.removeAttribute("destinationInterface");
            this.addQNameProperty(registration, "destinationInterface", destinationInterface, element);
        }
        if ((destinationOperation = element.getAttribute("destinationOperation")) != null) {
            element.removeAttribute("destinationOperation");
            this.addQNameProperty(registration, "destinationOperation", destinationOperation, element);
        }
        if ((failOnNoEndpoint = element.getAttribute("failIfNoDestinationEndpoint")) != null) {
            element.removeAttribute("failIfNoDestinationEndpoint");
            if (failOnNoEndpoint.length() > 0) {
                this.addPropertyElement(registration, "failIfNoDestinationEndpoint", failOnNoEndpoint);
            }
        }
        if ((persistent = element.getAttribute("persistent")) != null) {
            element.removeAttribute("persistent");
            if (persistent.length() > 0) {
                this.addPropertyElement(registration, "persistent", persistent);
            }
        }
        Element list = root.getOwnerDocument().createElement("list");
        boolean hasSubscriptions = false;
        NodeList childNodes = element.getChildNodes();
        int index = 0;
        while (index < childNodes.getLength() - 1) {
            Node node = childNodes.item(index);
            if (node.getNodeType() == 1 && node.getLocalName().equals("subscription")) {
                element.removeChild(node);
                list.appendChild(node);
                hasSubscriptions = true;
                continue;
            }
            ++index;
        }
        if (hasSubscriptions) {
            Element subscriptions = this.addPropertyElement(root, "subscriptions");
            subscriptions.appendChild(list);
            registration.appendChild(subscriptions);
        }
        DOMUtil.copyAttributes(element, bean);
        DOMUtil.moveContent(element, bean);
        root.removeChild(element);
        this.logXmlGenerated(log, "component generated", registration);
    }
}

