/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.config.ComponentElementProcessor;
import org.apache.servicemix.jbi.config.ComponentsElementProcessor;
import org.apache.servicemix.jbi.config.spring.CompositeElementProcessor;
import org.apache.servicemix.jbi.config.spring.ElementProcessor;
import org.apache.servicemix.jbi.config.spring.QNameElementProcessor;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServiceUnitElementProcessor
extends QNameElementProcessor
implements ElementProcessor {
    private static final transient Log log = LogFactory.getLog((Class)ServiceUnitElementProcessor.class);
    private static final CompositeElementProcessor compositeProcessor = new CompositeElementProcessor("", null){

        protected void loadLocalNameToProcessorMap() {
            this.registerProcessor("component", new ComponentElementProcessor());
            this.registerProcessor("components", new ComponentsElementProcessor());
            this.registerProcessor("qname", new QNameElementProcessor());
        }
    };

    public static CompositeElementProcessor getCompositeprocessor() {
        return compositeProcessor;
    }

    public void processElement(Element element, BeanDefinitionReader beanDefinitionReader) {
        String className;
        Document document = element.getOwnerDocument();
        Element root = (Element)element.getParentNode();
        Element bean = document.createElement("bean");
        root.appendChild(bean);
        DOMUtil.copyAttributes(element, bean);
        DOMUtil.moveContent(element, bean);
        root.removeChild(element);
        String id = bean.getAttribute("id");
        if (id == null || id.length() == 0) {
            bean.setAttribute("id", "jbi");
        }
        if ((className = bean.getAttribute("class")) == null || className.length() == 0) {
            bean.setAttribute("class", "org.apache.servicemix.jbi.container.SpringServiceUnitContainer");
        }
        this.processChildren(compositeProcessor, bean, beanDefinitionReader);
        this.logXmlGenerated(log, "container generated", bean);
    }
}

