/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.config.spring;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.config.spring.ElementProcessor;
import org.apache.servicemix.jbi.config.spring.ElementProcessorSupport;
import org.apache.servicemix.jbi.config.spring.QNameElementProcessor;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BeanElementProcessor
extends ElementProcessorSupport
implements ElementProcessor {
    private static final transient Log log = LogFactory.getLog((Class)BeanElementProcessor.class);
    private String className;
    private String textProperty;
    private ElementProcessor childProcessor;

    public BeanElementProcessor(String className) {
        this.className = className;
    }

    public BeanElementProcessor(String className, ElementProcessor childProcessor) {
        this.className = className;
        this.childProcessor = childProcessor;
    }

    public BeanElementProcessor(String className, String textProperty) {
        this.className = className;
        this.textProperty = textProperty;
    }

    public BeanElementProcessor(String className, String textProperty, ElementProcessor childProcessor) {
        this.className = className;
        this.textProperty = textProperty;
        this.childProcessor = childProcessor;
    }

    public BeanElementProcessor(Class type) {
        this(type.getName());
    }

    public void processElement(Element element, BeanDefinitionReader beanDefinitionReader) {
        this.logXmlGenerated(log, "processing Element", element);
        Element root = (Element)element.getParentNode();
        String tmp = element.getAttribute("class");
        if (tmp != null && tmp.length() > 0) {
            element.removeAttribute("class");
        } else {
            tmp = this.className;
        }
        Element bean = this.createBeanElement(root, element, tmp);
        this.turnAttributesIntoProperties(element, bean);
        DOMUtil.moveContent(element, bean);
        if (this.textProperty != null) {
            this.turnTextIntoProperty(bean);
        }
        root.removeChild(element);
        this.processBean(bean, beanDefinitionReader);
        this.logXmlGenerated(log, "component generated", bean);
    }

    protected void turnTextIntoProperty(Element bean) {
        String text = DOMUtil.getElementText(bean).trim();
        this.addPropertyElement(bean, this.textProperty, text);
        Node node = bean.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 3) {
                Node textNode = node;
                node = node.getNextSibling();
                bean.removeChild(textNode);
                continue;
            }
            node = node.getNextSibling();
        }
    }

    protected Element createBeanElement(Element root, Element element, String className) {
        Element bean = this.addBeanElement(root, className);
        return bean;
    }

    protected void processBean(Element bean, BeanDefinitionReader beanDefinitionReader) {
        if (this.childProcessor != null) {
            this.processChildren(this.childProcessor, bean, beanDefinitionReader);
        }
    }

    protected void turnAttributesIntoProperties(Element from, Element to) {
        NamedNodeMap attributes = from.getAttributes();
        int size = attributes.getLength();
        for (int i = 0; i < size; ++i) {
            Attr node = (Attr)attributes.item(i);
            if (node.getNodeName().startsWith("xmlns:")) {
                to.setAttribute(node.getNodeName(), node.getNodeValue());
                continue;
            }
            if (node.getNodeName().equals("service-name") || node.getNodeName().equals("interface-name")) {
                Element propertyElement = this.addPropertyElement(to, node.getName(), null);
                QNameElementProcessor qnameElementProcessor = new QNameElementProcessor();
                qnameElementProcessor.addQNameBeanElement(propertyElement, DOMUtil.createQName(from, node.getNodeValue()));
                continue;
            }
            this.addPropertyElement(to, node.getName(), node.getValue());
        }
    }
}

