/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.config.spring;

import org.apache.servicemix.jbi.config.spring.BeanElementProcessor;
import org.apache.servicemix.jbi.config.spring.ElementProcessor;
import org.w3c.dom.Element;

public class BeanPropertyElementProcessor
extends BeanElementProcessor {
    private String propertyName;

    public BeanPropertyElementProcessor(String className, String propertyName) {
        super(className);
        this.propertyName = propertyName;
    }

    public BeanPropertyElementProcessor(Class type, String propertyName) {
        this(type.getName(), propertyName);
    }

    public BeanPropertyElementProcessor(Class type, String propertyName, ElementProcessor processor) {
        super(type.getName(), processor);
        this.propertyName = propertyName;
    }

    protected Element createBeanElement(Element root, Element element, String className) {
        Element property = root.getOwnerDocument().createElement("property");
        String name = this.propertyName;
        if (name == null) {
            name = this.getElementNameToPropertyName(element);
        }
        property.setAttribute("name", name);
        root.appendChild(property);
        return super.createBeanElement(property, element, className);
    }
}

