/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.config.spring;

import org.apache.servicemix.jbi.config.spring.ElementProcessor;
import org.apache.servicemix.jbi.config.spring.ElementProcessorSupport;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class ElementToPropertyProcessor
extends ElementProcessorSupport
implements ElementProcessor {
    private String propertyName;

    public ElementToPropertyProcessor() {
    }

    public ElementToPropertyProcessor(String propertyName) {
        this.propertyName = propertyName;
    }

    public void processElement(Element element, BeanDefinitionReader beanDefinitionReader) {
        Element bean = (Element)element.getParentNode();
        bean.removeChild(element);
        String name = this.propertyName;
        if (name == null) {
            name = this.getElementNameToPropertyName(element);
        }
        this.addPropertyElement(bean, name, DOMUtil.getElementText(element));
        this.processAttributes(element, bean);
    }

    protected void processAttributes(Element element, Element bean) {
        NamedNodeMap attributes = element.getAttributes();
        int size = attributes.getLength();
        for (int i = 0; i < size; ++i) {
            Attr node = (Attr)attributes.item(i);
            String value = node.getValue();
            if (value == null || value.length() <= 0) continue;
            this.addPropertyElement(bean, node.getName(), value);
        }
    }
}

