/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.container;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.messaging.MessagingStats;

public class ComponentEnvironment {
    private static final Log log = LogFactory.getLog((Class)ComponentEnvironment.class);
    private File installRoot;
    private File workspaceRoot;
    private File componentRoot;
    private File stateFile;
    private File statsFile;
    private PrintWriter statsWriter;
    private ComponentMBeanImpl localConnector;

    public File getInstallRoot() {
        return this.installRoot;
    }

    public void setInstallRoot(File installRoot) {
        this.installRoot = installRoot;
    }

    public File getWorkspaceRoot() {
        return this.workspaceRoot;
    }

    public void setWorkspaceRoot(File workspaceRoot) {
        this.workspaceRoot = workspaceRoot;
    }

    public ComponentMBeanImpl getLocalConnector() {
        return this.localConnector;
    }

    public void setLocalConnector(ComponentMBeanImpl localConnector) {
        this.localConnector = localConnector;
    }

    public File getComponentRoot() {
        return this.componentRoot;
    }

    public void setComponentRoot(File componentRoot) {
        this.componentRoot = componentRoot;
    }

    public File getStateFile() {
        return this.stateFile;
    }

    public void setStateFile(File stateFile) {
        this.stateFile = stateFile;
    }

    public synchronized void close() {
        if (this.statsWriter != null) {
            this.statsWriter.close();
        }
    }

    public synchronized void dumpStats() {
        if (this.componentRoot != null && this.componentRoot.exists()) {
            try {
                if (this.statsWriter == null && this.statsFile != null) {
                    FileOutputStream fileOut = new FileOutputStream(this.statsFile);
                    this.statsWriter = new PrintWriter(fileOut, true);
                    this.statsWriter.println(this.localConnector.getComponentNameSpace().getName() + ":");
                    this.statsWriter.println("inboundExchanges,inboundExchangeRate,outboundExchanges,outboundExchangeRate");
                }
                MessagingStats stats = this.localConnector.getMessagingStats();
                long inbound = stats.getInboundExchanges().getCount();
                double inboundRate = stats.getInboundExchangeRate().getAveragePerSecond();
                long outbound = stats.getOutboundExchanges().getCount();
                double outboundRate = stats.getOutboundExchangeRate().getAveragePerSecond();
                this.statsWriter.println(inbound + "," + inboundRate + "," + outbound + "," + outboundRate);
            }
            catch (IOException e) {
                log.warn((Object)"Failed to dump stats", (Throwable)e);
            }
        }
    }

    public File getStatsFile() {
        return this.statsFile;
    }

    public void setStatsFile(File statsFile) {
        this.statsFile = statsFile;
    }
}

