/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.container;

import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.component.ServiceUnitManager;
import javax.resource.spi.work.WorkManager;
import org.apache.servicemix.components.util.ComponentAdaptor;
import org.apache.servicemix.jbi.container.ActivationSpec;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.jencks.factory.WorkManagerFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringJBIContainer
extends JBIContainer
implements InitializingBean,
DisposableBean,
BeanFactoryAware,
ApplicationContextAware {
    private String[] componentNames;
    private ActivationSpec[] activationSpecs;
    private BeanFactory beanFactory;
    private ApplicationContext applicationContext;
    private String[] deployArchives;
    private Object shutdownLock;

    public void afterPropertiesSet() throws Exception {
        int i;
        this.init();
        if (this.componentNames != null) {
            for (i = 0; i < this.componentNames.length; ++i) {
                String componentName = this.componentNames[i];
                this.activateComponent(new ActivationSpec(componentName, this.lookupBean(componentName)));
            }
        }
        if (this.activationSpecs != null) {
            for (i = 0; i < this.activationSpecs.length; ++i) {
                ActivationSpec activationSpec = this.activationSpecs[i];
                this.activateComponent(activationSpec);
            }
        }
        if (this.deployArchives != null) {
            for (i = 0; i < this.deployArchives.length; ++i) {
                String archive = this.deployArchives[i];
                this.installArchive(archive);
            }
        }
        this.start();
    }

    public void stop() throws JBIException {
        if (this.beanFactory instanceof DisposableBean) {
            DisposableBean disposable = (DisposableBean)this.beanFactory;
            try {
                disposable.destroy();
            }
            catch (Exception e) {
                throw new JBIException("Failed to dispose of the Spring BeanFactory due to: " + e, (Throwable)e);
            }
        }
        super.stop();
    }

    public Object getBean(String id) {
        Component bean;
        ComponentMBeanImpl component = this.getComponent(id);
        Component component2 = bean = component != null ? component.getComponent() : null;
        if (bean instanceof ComponentAdaptor) {
            bean = ((ComponentAdaptor)bean).getLifeCycle();
        }
        return bean;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public String[] getComponentNames() {
        return this.componentNames;
    }

    public void setComponentNames(String[] componentNames) {
        this.componentNames = componentNames;
    }

    public ServiceUnitManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(ServiceUnitManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public ActivationSpec[] getActivationSpecs() {
        return this.activationSpecs;
    }

    public void setActivationSpecs(ActivationSpec[] activationSpecs) throws JBIException {
        this.activationSpecs = activationSpecs;
    }

    public String[] getDeployArchives() {
        return this.deployArchives;
    }

    public void setDeployArchives(String[] deployArchives) {
        this.deployArchives = deployArchives;
    }

    protected Object lookupBean(String componentName) {
        Object bean = this.beanFactory.getBean(componentName);
        if (bean == null) {
            throw new IllegalArgumentException("Component name: " + componentName + " is not found in the Spring BeanFactory");
        }
        return bean;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected WorkManager createWorkManager() throws JBIException {
        WorkManagerFactoryBean factory = new WorkManagerFactoryBean();
        factory.setApplicationContext(this.applicationContext);
        try {
            return factory.getWorkManager();
        }
        catch (Exception e) {
            throw new JBIException("Failed to start WorkManager: " + e, (Throwable)e);
        }
    }

    public void destroy() throws Exception {
        super.shutDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() throws JBIException {
        if (this.shutdownLock != null) {
            Object object = this.shutdownLock;
            synchronized (object) {
                this.shutdownLock.notify();
            }
        }
    }

    public void setShutdownLock(Object lock) {
        this.shutdownLock = lock;
    }
}

