/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployment;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.config.spring.XBeanProcessor;
import org.apache.servicemix.jbi.deployment.Component;
import org.apache.servicemix.jbi.deployment.Descriptor;
import org.apache.servicemix.jbi.util.FileUtil;
import org.apache.xbean.spring.context.ResourceXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class DescriptorFactory {
    public static final String DESCRIPTOR_FILE = "META-INF/jbi.xml";
    private static Log log = LogFactory.getLog((Class)DescriptorFactory.class);

    public static Descriptor buildDescriptor(File descriptorFile) {
        if (descriptorFile.isDirectory()) {
            descriptorFile = new File(descriptorFile, DESCRIPTOR_FILE);
        }
        if (descriptorFile.isFile()) {
            try {
                return DescriptorFactory.buildDescriptor(descriptorFile.toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("There is a bug here...", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Descriptor buildDescriptor(URL url) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(DescriptorFactory.class.getClassLoader());
            ResourceXmlApplicationContext context = new ResourceXmlApplicationContext((Resource)new UrlResource(url), Arrays.asList(new XBeanProcessor()));
            Descriptor descriptor = (Descriptor)context.getBean("jbi");
            DescriptorFactory.checkDescriptor(descriptor);
            Descriptor descriptor2 = descriptor;
            return descriptor2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static void checkDescriptor(Descriptor descriptor) {
        ArrayList voilations = new ArrayList();
        if (descriptor.getComponent() != null) {
            DescriptorFactory.checkComponent(voilations, descriptor.getComponent());
        }
        if (voilations.size() > 0) {
            throw new RuntimeException("The JBI descriptor is not valid, please correct these voilations " + ((Object)voilations).toString() + "");
        }
    }

    private static void checkComponent(List voilations, Component component) {
        if (component.getBootstrapClassName() == null) {
            voilations.add("The component has not defined a boot-strap class name");
        }
        if (component.getBootstrapClassPath() == null || component.getBootstrapClassPath().getPathElements() == null) {
            voilations.add("The component has not defined any boot-strap class path elements");
        }
    }

    public static String getDescriptorAsText(File descriptorFile) {
        if (descriptorFile.isDirectory()) {
            descriptorFile = new File(descriptorFile, DESCRIPTOR_FILE);
        }
        if (descriptorFile.isFile()) {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                FileInputStream is = new FileInputStream(descriptorFile);
                FileUtil.copyInputStream(is, os);
                return os.toString();
            }
            catch (Exception e) {
                log.debug((Object)("Error reading jbi descritor: " + descriptorFile), (Throwable)e);
            }
        }
        return null;
    }
}

