/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployment.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.config.spring.ElementProcessor;
import org.apache.servicemix.jbi.config.spring.ElementProcessorSupport;
import org.apache.servicemix.jbi.deployment.Descriptor;
import org.apache.servicemix.jbi.deployment.impl.JbiNamespaceProcessor;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JbiElementProcessor
extends ElementProcessorSupport
implements ElementProcessor {
    private static final transient Log log = LogFactory.getLog((Class)JbiElementProcessor.class);
    private static final JbiNamespaceProcessor compositeProcessor = new JbiNamespaceProcessor();

    public void processElement(Element element, BeanDefinitionReader beanDefinitionReader) {
        Document document = element.getOwnerDocument();
        Element beans = document.createElement("beans");
        document.removeChild(element);
        document.appendChild(beans);
        Element bean = this.addBeanElement(beans, Descriptor.class.getName());
        DOMUtil.copyAttributes(element, beans);
        DOMUtil.moveContent(element, bean);
        beans.removeAttribute("xmlns");
        String id = bean.getAttribute("id");
        if (id == null || id.length() == 0) {
            bean.setAttribute("id", "jbi");
        }
        bean.setAttribute("singleton", "true");
        this.moveToProperyListElement(bean, "path-element", "pathElements");
        this.moveToProperyListElement(bean, "service-unit", "serviceUnits");
        this.moveToProperyListElement(bean, "connection", "connections");
        this.moveToProperyListElement(bean, "provides", "provides");
        this.moveToProperyListElement(bean, "consumes", "consumes");
        this.processChildren(compositeProcessor, bean, beanDefinitionReader);
        this.logXmlGenerated(log, "Adding new beans", beans);
    }

    protected void moveToProperyListElement(Element bean, String elementName, String propertyName) {
        Element property = null;
        Node to = null;
        Node node = bean.getFirstChild();
        while (node != null) {
            Node current = node;
            node = node.getNextSibling();
            if (current.getNodeType() != 1) continue;
            if (elementName.equals(current.getNodeName())) {
                bean.removeChild(current);
                if (to == null) {
                    property = this.addPropertyElement(bean, propertyName);
                    to = this.addElement(property, "list");
                    bean.removeChild(property);
                }
                to.appendChild(current);
                continue;
            }
            this.moveToProperyListElement((Element)current, elementName, propertyName);
        }
        if (property != null) {
            bean.appendChild(property);
        }
    }
}

