/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.container.EnvironmentContext;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.deployment.Component;
import org.apache.servicemix.jbi.deployment.Descriptor;
import org.apache.servicemix.jbi.deployment.DescriptorFactory;
import org.apache.servicemix.jbi.deployment.ServiceAssembly;
import org.apache.servicemix.jbi.framework.AutoDeploymentServiceMBean;
import org.apache.servicemix.jbi.framework.DeploymentService;
import org.apache.servicemix.jbi.framework.InstallationService;
import org.apache.servicemix.jbi.framework.ManagementSupport;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.BaseSystemService;
import org.apache.servicemix.jbi.util.FileUtil;
import org.apache.servicemix.jbi.util.XmlPersistenceSupport;

public class AutoDeploymentService
extends BaseSystemService
implements AutoDeploymentServiceMBean {
    private static final Log log = LogFactory.getLog((Class)AutoDeploymentService.class);
    private EnvironmentContext environmentContext;
    private DeploymentService deploymentService;
    private InstallationService installationService;
    private boolean monitorInstallationDirectory = true;
    private boolean monitorDeploymentDirectory = true;
    private int monitorInterval = 10;
    private AtomicBoolean started = new AtomicBoolean(false);
    private Timer statsTimer;
    private TimerTask timerTask;
    private Map pendingComponents = new ConcurrentHashMap();
    private Map pendingSAs = new ConcurrentHashMap();
    private Map installFileMap = null;
    private Map deployFileMap = null;

    public String getDescription() {
        return "automatically installs and deploys JBI Archives";
    }

    public boolean isMonitorInstallationDirectory() {
        return this.monitorInstallationDirectory;
    }

    public void setMonitorInstallationDirectory(boolean monitorInstallationDirectory) {
        this.monitorInstallationDirectory = monitorInstallationDirectory;
    }

    public boolean isMonitorDeploymentDirectory() {
        return this.monitorDeploymentDirectory;
    }

    public void setMonitorDeploymentDirectory(boolean monitorDeploymentDirectory) {
        this.monitorDeploymentDirectory = monitorDeploymentDirectory;
    }

    public int getMonitorInterval() {
        return this.monitorInterval;
    }

    public void setMonitorInterval(int monitorInterval) {
        this.monitorInterval = monitorInterval;
    }

    public void start() throws JBIException {
        super.start();
        if (this.started.compareAndSet(false, true)) {
            this.scheduleDirectoryTimer();
        }
    }

    public void stop() throws JBIException {
        if (this.started.compareAndSet(true, false)) {
            super.stop();
            if (this.timerTask != null) {
                this.timerTask.cancel();
            }
        }
    }

    public void init(JBIContainer container) throws JBIException {
        super.init(container);
        this.environmentContext = container.getEnvironmentContext();
        this.installationService = container.getInstallationService();
        this.deploymentService = container.getDeploymentService();
        if (this.environmentContext.getTmpDir() != null) {
            FileUtil.deleteFile(this.environmentContext.getTmpDir());
        }
        this.initializeFileMaps();
    }

    protected Class getServiceMBean() {
        return AutoDeploymentServiceMBean.class;
    }

    public ArchiveEntry updateExternalArchive(String location, boolean autoStart) throws DeploymentException {
        ArchiveEntry entry = new ArchiveEntry();
        entry.location = location;
        entry.lastModified = new Date();
        this.updateArchive(location, entry, autoStart);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateArchive(String location, ArchiveEntry entry, boolean autoStart) throws DeploymentException {
        block29: {
            File tmpDir = null;
            try {
                tmpDir = AutoDeploymentService.unpackLocation(this.environmentContext.getTmpDir(), location);
            }
            catch (Exception e) {
                throw this.failure("deploy", "Unable to unpack archive: " + location, e);
            }
            if (tmpDir == null) {
                throw this.failure("deploy", "Unable to find jbi descriptor: " + location);
            }
            Descriptor root = null;
            try {
                root = DescriptorFactory.buildDescriptor(tmpDir);
            }
            catch (Exception e) {
                throw this.failure("deploy", "Unable to build jbi descriptor: " + location, e);
            }
            if (root == null) {
                throw this.failure("deploy", "Unable to find jbi descriptor: " + location);
            }
            if (root != null) {
                try {
                    this.container.getBroker().suspend();
                    if (root.getComponent() != null) {
                        Component comp = root.getComponent();
                        String componentName = comp.getIdentification().getName();
                        entry.type = "component";
                        entry.name = componentName;
                        try {
                            if (this.container.getRegistry().getComponent(componentName) != null) {
                                this.installationService.unloadInstaller(componentName, true);
                            }
                            entry.dependencies = this.getSharedLibraryNames(comp);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Component dependencies: " + entry.dependencies));
                            }
                            String missings = null;
                            boolean canInstall = true;
                            Iterator it = entry.dependencies.iterator();
                            while (it.hasNext()) {
                                String libraryName = (String)it.next();
                                if (this.container.getRegistry().getSharedLibrary(libraryName) != null) continue;
                                canInstall = false;
                                if (missings != null) {
                                    missings = missings + ", " + libraryName;
                                    continue;
                                }
                                missings = libraryName;
                            }
                            if (canInstall) {
                                this.installationService.install(tmpDir, null, root, autoStart);
                                this.checkPendingSAs();
                            } else {
                                entry.pending = true;
                                log.info((Object)("Shared libraries " + missings + " are not installed yet - adding Component " + componentName + " to pending list"));
                                this.pendingComponents.put(tmpDir, entry);
                            }
                            break block29;
                        }
                        catch (Exception e) {
                            String errStr = "Failed to update Component: " + componentName;
                            log.error((Object)errStr, (Throwable)e);
                            throw new DeploymentException(errStr, (Throwable)e);
                        }
                    }
                    if (root.getSharedLibrary() != null) {
                        String libraryName = root.getSharedLibrary().getIdentification().getName();
                        entry.type = "library";
                        entry.name = libraryName;
                        this.installationService.doInstallSharedLibrary(tmpDir, root.getSharedLibrary());
                        this.checkPendingComponents();
                        break block29;
                    }
                    if (root.getServiceAssembly() == null) break block29;
                    ServiceAssembly sa = root.getServiceAssembly();
                    String name = sa.getIdentification().getName();
                    entry.type = "assembly";
                    entry.name = name;
                    try {
                        if (this.deploymentService.isSaDeployed(name)) {
                            this.deploymentService.shutDown(name);
                            this.deploymentService.undeploy(name);
                        }
                        entry.dependencies = this.getComponentNames(sa);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("SA dependencies: " + entry.dependencies));
                        }
                        String missings = null;
                        boolean canDeploy = true;
                        Iterator it = entry.dependencies.iterator();
                        while (it.hasNext()) {
                            String componentName = (String)it.next();
                            if (this.container.getComponent(componentName) != null) continue;
                            canDeploy = false;
                            if (missings != null) {
                                missings = missings + ", " + componentName;
                                continue;
                            }
                            missings = componentName;
                        }
                        if (canDeploy) {
                            this.deploymentService.deployServiceAssembly(tmpDir, sa);
                            if (autoStart) {
                                this.deploymentService.start(name);
                            }
                        } else {
                            entry.pending = true;
                            log.info((Object)("Components " + missings + " are not installed yet - adding ServiceAssembly " + name + " to pending list"));
                            this.pendingSAs.put(tmpDir, entry);
                        }
                    }
                    catch (Exception e) {
                        String errStr = "Failed to update Service Assembly: " + name;
                        log.error((Object)errStr, (Throwable)e);
                        throw new DeploymentException(errStr, (Throwable)e);
                    }
                }
                finally {
                    this.container.getBroker().resume();
                }
            }
        }
    }

    protected DeploymentException failure(String task, String info) {
        return this.failure(task, info, null, null);
    }

    protected DeploymentException failure(String task, String info, Exception e) {
        return this.failure(task, info, e, null);
    }

    protected DeploymentException failure(String task, String info, Exception e, List componentResults) {
        ManagementSupport.Message msg = new ManagementSupport.Message();
        msg.setTask(task);
        msg.setResult("FAILED");
        msg.setType("ERROR");
        msg.setException(e);
        msg.setMessage(info);
        return new DeploymentException(ManagementSupport.createFrameworkMessage(msg, componentResults));
    }

    protected Set getComponentNames(ServiceAssembly sa) {
        HashSet<String> names = new HashSet<String>();
        if (sa.getServiceUnits() != null && sa.getServiceUnits().length > 0) {
            for (int i = 0; i < sa.getServiceUnits().length; ++i) {
                names.add(sa.getServiceUnits()[i].getTarget().getComponentName());
            }
        }
        return names;
    }

    protected Set getSharedLibraryNames(Component comp) {
        HashSet<String> names = new HashSet<String>();
        if (comp.getSharedLibraries() != null && comp.getSharedLibraries().length > 0) {
            for (int i = 0; i < comp.getSharedLibraries().length; ++i) {
                names.add(comp.getSharedLibraries()[i].getName());
            }
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeArchive(ArchiveEntry entry) throws DeploymentException {
        block8: {
            log.info((Object)("Attempting to remove archive at: " + entry.location));
            try {
                this.container.getBroker().suspend();
                if ("component".equals(entry.type)) {
                    log.info((Object)("Uninstalling component: " + entry.name));
                    this.installationService.loadInstaller(entry.name);
                    this.installationService.unloadInstaller(entry.name, true);
                }
                if ("library".equals(entry.type)) {
                    log.info((Object)("Removing shared library: " + entry.name));
                    this.installationService.uninstallSharedLibrary(entry.name);
                }
                if (!"assembly".equals(entry.type)) break block8;
                log.info((Object)("Undeploying service assembly " + entry.name));
                try {
                    if (this.deploymentService.isSaDeployed(entry.name)) {
                        this.deploymentService.shutDown(entry.name);
                        this.deploymentService.undeploy(entry.name);
                    }
                }
                catch (Exception e) {
                    String errStr = "Failed to update service assembly: " + entry.name;
                    log.error((Object)errStr, (Throwable)e);
                    throw new DeploymentException(errStr, (Throwable)e);
                }
            }
            finally {
                this.container.getBroker().resume();
            }
        }
    }

    private void checkPendingSAs() {
        HashSet<File> deployedSas = new HashSet<File>();
        Iterator it = this.pendingSAs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            ArchiveEntry entry = (ArchiveEntry)me.getValue();
            boolean canDeploy = true;
            Iterator it2 = entry.dependencies.iterator();
            while (it2.hasNext()) {
                String componentName = (String)it2.next();
                if (this.container.getComponent(componentName) != null) continue;
                canDeploy = false;
                break;
            }
            if (!canDeploy) continue;
            File tmp = (File)me.getKey();
            deployedSas.add(tmp);
            try {
                Descriptor root = DescriptorFactory.buildDescriptor(tmp);
                this.deploymentService.deployServiceAssembly(tmp, root.getServiceAssembly());
                this.deploymentService.start(root.getServiceAssembly().getIdentification().getName());
            }
            catch (Exception e) {
                String errStr = "Failed to update Service Assembly: " + tmp.getName();
                log.error((Object)errStr, (Throwable)e);
            }
        }
        if (!deployedSas.isEmpty()) {
            it = deployedSas.iterator();
            while (it.hasNext()) {
                ArchiveEntry entry = (ArchiveEntry)this.pendingSAs.remove(it.next());
                entry.pending = false;
            }
            this.persistState(this.environmentContext.getDeploymentDir(), this.deployFileMap);
            this.persistState(this.environmentContext.getInstallationDir(), this.installFileMap);
        }
    }

    private void checkPendingComponents() {
        HashSet<File> installedComponents = new HashSet<File>();
        Iterator it = this.pendingComponents.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            ArchiveEntry entry = (ArchiveEntry)me.getValue();
            boolean canInstall = true;
            Iterator it2 = entry.dependencies.iterator();
            while (it2.hasNext()) {
                String libraryName = (String)it2.next();
                if (this.container.getRegistry().getSharedLibrary(libraryName) != null) continue;
                canInstall = false;
                break;
            }
            if (!canInstall) continue;
            File tmp = (File)me.getKey();
            installedComponents.add(tmp);
            try {
                Descriptor root = DescriptorFactory.buildDescriptor(tmp);
                this.installationService.install(tmp, null, root, true);
            }
            catch (Exception e) {
                String errStr = "Failed to update Component: " + tmp.getName();
                log.error((Object)errStr, (Throwable)e);
            }
        }
        if (!installedComponents.isEmpty()) {
            it = installedComponents.iterator();
            while (it.hasNext()) {
                ArchiveEntry entry = (ArchiveEntry)this.pendingComponents.remove(it.next());
                entry.pending = false;
            }
            this.persistState(this.environmentContext.getDeploymentDir(), this.deployFileMap);
            this.persistState(this.environmentContext.getInstallationDir(), this.installFileMap);
            this.checkPendingSAs();
        }
    }

    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "monitorInstallationDirectory", "Periodically monitor the Installation directory");
        helper.addAttribute(this.getObjectToManage(), "monitorInterval", "Interval (secs) before monitoring");
        return AttributeInfoHelper.join(super.getAttributeInfos(), helper.getAttributeInfos());
    }

    protected static File unpackLocation(File tmpRoot, String location) throws DeploymentException {
        File tmpDir = null;
        try {
            File file = new File(location);
            if (file.isDirectory()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Deploying an exploded jar/zip, we will create a temporary jar for it.");
                }
                File newFile = new File(tmpRoot.getAbsolutePath() + "/exploded.jar");
                newFile.delete();
                FileUtil.zipDir(file.getAbsolutePath(), newFile.getAbsolutePath());
                file = newFile;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deployment will now work from " + file.getAbsolutePath()));
                }
            }
            if (!file.exists()) {
                try {
                    URL url = new URL(location);
                    String fileName = url.getFile();
                    if (fileName == null || !fileName.endsWith(".zip") && !fileName.endsWith(".jar")) {
                        throw new DeploymentException("Location: " + location + " is not an archive");
                    }
                    file = FileUtil.unpackArchive(url, tmpRoot);
                }
                catch (MalformedURLException e) {
                    throw new DeploymentException((Throwable)e);
                }
            }
            if (FileUtil.archiveContainsEntry(file, "META-INF/jbi.xml")) {
                tmpDir = FileUtil.createUniqueDirectory(tmpRoot, file.getName());
                FileUtil.unpackArchive(file, tmpDir);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Unpacked archive " + location + " to " + tmpDir));
                }
            }
        }
        catch (IOException e) {
            throw new DeploymentException((Throwable)e);
        }
        return tmpDir;
    }

    private void scheduleDirectoryTimer() {
        if (!this.container.isEmbedded() && (this.isMonitorInstallationDirectory() || this.isMonitorDeploymentDirectory())) {
            if (this.statsTimer == null) {
                this.statsTimer = new Timer(true);
            }
            if (this.timerTask != null) {
                this.timerTask.cancel();
            }
            this.timerTask = new TimerTask(){

                public void run() {
                    if (AutoDeploymentService.this.isMonitorInstallationDirectory()) {
                        AutoDeploymentService.this.monitorDirectory(AutoDeploymentService.this.environmentContext.getInstallationDir(), AutoDeploymentService.this.installFileMap);
                    }
                    if (AutoDeploymentService.this.isMonitorDeploymentDirectory()) {
                        AutoDeploymentService.this.monitorDirectory(AutoDeploymentService.this.environmentContext.getDeploymentDir(), AutoDeploymentService.this.deployFileMap);
                    }
                }
            };
            long interval = this.monitorInterval * 1000;
            this.statsTimer.scheduleAtFixedRate(this.timerTask, 0L, interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorDirectory(final File root, Map fileMap) {
        if (root != null) {
            log.debug((Object)("Monitoring directory " + root.getAbsolutePath() + " for new or modified archives"));
        } else {
            log.debug((Object)("No directory to monitor for new or modified archives for " + (fileMap == this.installFileMap ? "Installation" : "Deployment") + "."));
        }
        ArrayList<String> tmpList = new ArrayList<String>();
        if (root != null && root.exists() && root.isDirectory()) {
            ArchiveEntry entry;
            File[] files = root.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    ArchiveEntry lastEntry;
                    final File file = files[i];
                    tmpList.add(file.getName());
                    if (!file.getPath().endsWith(".jar") && !file.getPath().endsWith(".zip") || (lastEntry = (ArchiveEntry)fileMap.get(file.getName())) != null && file.lastModified() <= lastEntry.lastModified.getTime()) continue;
                    try {
                        entry = new ArchiveEntry();
                        entry.location = file.getName();
                        entry.lastModified = new Date(file.lastModified());
                        fileMap.put(file.getName(), entry);
                        this.container.getWorkManager().doWork(new Work(){

                            public void run() {
                                log.info((Object)("Directory: " + root.getName() + ": Archive changed: processing " + file.getName() + " ..."));
                                try {
                                    AutoDeploymentService.this.updateArchive(file.getAbsolutePath(), entry, true);
                                    log.info((Object)("Directory: " + root.getName() + ": Finished installation of archive:  " + file.getName()));
                                }
                                catch (Exception e) {
                                    log.warn((Object)("Directory: " + root.getName() + ": Automatic install of " + file + " failed"), (Throwable)e);
                                }
                            }

                            public void release() {
                            }
                        });
                        continue;
                    }
                    catch (WorkException e) {
                        log.warn((Object)("Automatic install of " + file + " failed"), (Throwable)e);
                        continue;
                    }
                    finally {
                        this.persistState(root, fileMap);
                    }
                }
            }
            HashMap map = new HashMap(fileMap);
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                String location = i.next().toString();
                if (tmpList.contains(location)) continue;
                entry = (ArchiveEntry)fileMap.remove(location);
                try {
                    log.info((Object)("Location " + location + " no longer exists - removing ..."));
                    this.removeArchive(entry);
                }
                catch (DeploymentException e) {
                    log.error((Object)("Failed to removeArchive: " + location), (Throwable)e);
                }
            }
            if (!((Object)map).equals(fileMap)) {
                this.persistState(root, fileMap);
            }
        }
    }

    private void persistState(File root, Map map) {
        try {
            File file = new File(this.environmentContext.getJbiRootDir(), root.getName() + ".xml");
            XmlPersistenceSupport.write(file, map);
        }
        catch (IOException e) {
            log.error((Object)("Failed to persist file state to: " + root), (Throwable)e);
        }
    }

    private Map readState(File root) {
        Map result = new HashMap();
        try {
            File file = new File(this.environmentContext.getJbiRootDir(), root.getName() + ".xml");
            if (file.exists()) {
                result = (Map)XmlPersistenceSupport.read(file);
            } else {
                log.debug((Object)("State file doesn't exist: " + file.getPath()));
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to read file state from: " + root), (Throwable)e);
        }
        return result;
    }

    private void initializeFileMaps() {
        if (this.isMonitorInstallationDirectory() && !this.container.isEmbedded()) {
            try {
                this.installFileMap = this.readState(this.environmentContext.getInstallationDir());
                this.removePendingEntries(this.installFileMap);
            }
            catch (Exception e) {
                log.error((Object)"Failed to read installed state", (Throwable)e);
            }
        }
        if (this.isMonitorDeploymentDirectory() && !this.container.isEmbedded()) {
            try {
                this.deployFileMap = this.readState(this.environmentContext.getDeploymentDir());
                this.removePendingEntries(this.deployFileMap);
            }
            catch (Exception e) {
                log.error((Object)"Failed to read deployed state", (Throwable)e);
            }
        }
    }

    private void removePendingEntries(Map map) {
        HashSet pendings = new HashSet();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            if (!((ArchiveEntry)e.getValue()).pending) continue;
            pendings.add(e.getKey());
        }
        it = pendings.iterator();
        while (it.hasNext()) {
            map.remove(it.next());
        }
    }

    public static class ArchiveEntry {
        public String location;
        public Date lastModified;
        public String type;
        public String name;
        public boolean pending;
        public transient Set dependencies;
    }
}

