/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.framework.ComponentNameSpace;
import org.apache.servicemix.jbi.framework.Registry;

public class ComponentRegistry {
    private Map idMap = new LinkedHashMap();
    private boolean runningStateInitialized = false;
    private Registry registry;

    protected ComponentRegistry(Registry reg) {
        this.registry = reg;
    }

    public synchronized ComponentMBeanImpl registerComponent(ComponentNameSpace name, String description, Component component, boolean binding, boolean service, String[] sharedLibraries) {
        ComponentMBeanImpl result = null;
        if (!this.idMap.containsKey(name)) {
            result = new ComponentMBeanImpl(this.registry.getContainer(), name, description, component, binding, service, sharedLibraries);
            this.idMap.put(name, result);
        }
        return result;
    }

    public synchronized void start() throws JBIException {
        if (!this.setInitialRunningStateFromStart()) {
            Iterator i = this.getComponents().iterator();
            while (i.hasNext()) {
                ComponentMBeanImpl lcc = (ComponentMBeanImpl)i.next();
                lcc.doStart();
            }
        }
    }

    public synchronized void stop() throws JBIException {
        Iterator i = this.getReverseComponents().iterator();
        while (i.hasNext()) {
            ComponentMBeanImpl lcc = (ComponentMBeanImpl)i.next();
            lcc.doStop();
        }
        this.runningStateInitialized = false;
    }

    public synchronized void shutDown() throws JBIException {
        Iterator i = this.getReverseComponents().iterator();
        while (i.hasNext()) {
            ComponentMBeanImpl lcc = (ComponentMBeanImpl)i.next();
            lcc.persistRunningState();
            lcc.doShutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getReverseComponents() {
        Map map = this.idMap;
        synchronized (map) {
            ArrayList l = new ArrayList(this.idMap.values());
            Collections.reverse(l);
            return l;
        }
    }

    public synchronized void deregisterComponent(ComponentMBeanImpl component) {
        this.idMap.remove(component.getComponentNameSpace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentMBeanImpl getComponent(ComponentNameSpace id) {
        Map map = this.idMap;
        synchronized (map) {
            return (ComponentMBeanImpl)this.idMap.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getComponents() {
        Map map = this.idMap;
        synchronized (map) {
            return new ArrayList(this.idMap.values());
        }
    }

    private boolean setInitialRunningStateFromStart() throws JBIException {
        boolean result;
        boolean bl = result = !this.runningStateInitialized;
        if (!this.runningStateInitialized) {
            this.runningStateInitialized = true;
            Iterator i = this.getComponents().iterator();
            while (i.hasNext()) {
                ComponentMBeanImpl lcc = (ComponentMBeanImpl)i.next();
                if (!lcc.isPojo() && !this.registry.isContainerEmbedded()) {
                    lcc.setInitialRunningState();
                    continue;
                }
                lcc.doStart();
            }
        }
        return result;
    }
}

