/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.framework.ComponentStatsMBean;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.BaseLifeCycle;
import org.apache.servicemix.jbi.management.OperationInfoHelper;

public class ComponentStats
extends BaseLifeCycle
implements ComponentStatsMBean {
    private ComponentMBeanImpl component;

    public ComponentStats(ComponentMBeanImpl component) {
        this.component = component;
    }

    public String getType() {
        return "Component";
    }

    public String getSubType() {
        return "Statistics";
    }

    public String getName() {
        return this.component.getName();
    }

    public String getDescription() {
        return "Statistics for " + this.component.getDescription();
    }

    public long getInboundExchangeCount() {
        return this.component.getMessagingStats().getInboundExchanges().getCount();
    }

    public double getInboundExchangeRate() {
        return this.component.getMessagingStats().getInboundExchangeRate().getAverageTime();
    }

    public long getOutboundExchangeCount() {
        return this.component.getMessagingStats().getOutboundExchanges().getCount();
    }

    public double getOutboundExchangeRate() {
        return this.component.getMessagingStats().getOutboundExchangeRate().getAverageTime();
    }

    public int getInboundQueueSize() {
        if (this.component.getDeliveryChannel() != null) {
            return this.component.getDeliveryChannel().getQueueSize();
        }
        return 0;
    }

    public void reset() {
        this.component.getMessagingStats().reset();
    }

    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "inboundQueueSize", "size of the inbound queue");
        helper.addAttribute(this.getObjectToManage(), "inboundExchangeCount", "count of inbound exchanges");
        helper.addAttribute(this.getObjectToManage(), "outboundExchangeCount", "count of outbound exchanges");
        helper.addAttribute(this.getObjectToManage(), "inboundExchangeRate", "rate of inbound exchanges/sec");
        helper.addAttribute(this.getObjectToManage(), "outboundExchangeRate", "rate of outbound exchanges/sec");
        return helper.getAttributeInfos();
    }

    public MBeanOperationInfo[] getOperationInfos() {
        OperationInfoHelper helper = new OperationInfoHelper();
        helper.addOperation(this.getObjectToManage(), "reset", "reset statistic counters");
        return helper.getOperationInfos();
    }
}

