/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.deployment.Provides;
import org.apache.servicemix.jbi.deployment.Services;
import org.apache.servicemix.jbi.event.EndpointEvent;
import org.apache.servicemix.jbi.event.EndpointListener;
import org.apache.servicemix.jbi.framework.ComponentContextImpl;
import org.apache.servicemix.jbi.framework.ComponentNameSpace;
import org.apache.servicemix.jbi.framework.Endpoint;
import org.apache.servicemix.jbi.framework.EndpointMBean;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.framework.ServiceUnitLifeCycle;
import org.apache.servicemix.jbi.servicedesc.AbstractServiceEndpoint;
import org.apache.servicemix.jbi.servicedesc.ExternalEndpoint;
import org.apache.servicemix.jbi.servicedesc.InternalEndpoint;
import org.apache.servicemix.jbi.servicedesc.LinkedEndpoint;
import org.w3c.dom.Document;

public class EndpointRegistry {
    private static final Log logger = LogFactory.getLog((Class)EndpointRegistry.class);
    private Registry registry;
    private Map endpointMBeans;
    private Map internalEndpoints;
    private Map externalEndpoints;
    private Map linkedEndpoints;
    private Map interfaceConnections;

    public EndpointRegistry(Registry registry) {
        this.registry = registry;
        this.endpointMBeans = new ConcurrentHashMap();
        this.internalEndpoints = new ConcurrentHashMap();
        this.externalEndpoints = new ConcurrentHashMap();
        this.linkedEndpoints = new ConcurrentHashMap();
        this.interfaceConnections = new ConcurrentHashMap();
    }

    public ServiceEndpoint[] getEndpointsForComponent(ComponentNameSpace cns) {
        ArrayList<InternalEndpoint> endpoints = new ArrayList<InternalEndpoint>();
        Iterator iter = this.getInternalEndpoints().iterator();
        while (iter.hasNext()) {
            InternalEndpoint endpoint = (InternalEndpoint)iter.next();
            if (!cns.equals(endpoint.getComponentNameSpace())) continue;
            endpoints.add(endpoint);
        }
        return this.asEndpointArray(endpoints);
    }

    public Collection getEndpointMBeans() {
        return this.endpointMBeans.values();
    }

    public ServiceEndpoint[] getEndpointsForService(QName serviceName) {
        Collection collection = this.getEndpointsByService(serviceName, this.getInternalEndpoints());
        return this.asEndpointArray(collection);
    }

    public ServiceEndpoint[] getEndpointsForInterface(QName interfaceName) {
        if (interfaceName == null) {
            return this.asEndpointArray(this.internalEndpoints.values());
        }
        InterfaceConnection conn = (InterfaceConnection)this.interfaceConnections.get(interfaceName);
        if (conn != null) {
            String key = this.getKey(conn.service, conn.endpoint);
            ServiceEndpoint ep = (ServiceEndpoint)this.internalEndpoints.get(key);
            if (ep == null) {
                logger.warn((Object)("Connection for interface " + interfaceName + " could not find target for service " + conn.service + " and endpoint " + conn.endpoint));
                return new ServiceEndpoint[0];
            }
            return new ServiceEndpoint[]{ep};
        }
        Collection result = this.getEndpointsByInterface(interfaceName, this.getInternalEndpoints());
        return this.asEndpointArray(result);
    }

    public InternalEndpoint registerInternalEndpoint(ComponentContextImpl provider, QName serviceName, String endpointName) throws JBIException {
        String key = this.getKey(serviceName, endpointName);
        InternalEndpoint registered = (InternalEndpoint)this.internalEndpoints.get(key);
        if (registered != null && registered.isLocal()) {
            throw new JBIException("An internal endpoint for service " + serviceName + " and endpoint " + endpointName + " is already registered");
        }
        InternalEndpoint serviceEndpoint = new InternalEndpoint(provider.getComponentNameSpace(), endpointName, serviceName);
        if (provider.getActivationSpec().getInterfaceName() != null) {
            serviceEndpoint.addInterface(provider.getActivationSpec().getInterfaceName());
        }
        this.retrieveInterfaceFromSUDescriptor(serviceEndpoint);
        this.retrieveInterfacesFromDescription(serviceEndpoint);
        if (registered != null) {
            InternalEndpoint[] remote = registered.getRemoteEndpoints();
            for (int i = 0; i < remote.length; ++i) {
                serviceEndpoint.addRemoteEndpoint(remote[i]);
            }
        }
        this.internalEndpoints.put(key, serviceEndpoint);
        this.registerEndpoint(serviceEndpoint);
        this.fireEvent(serviceEndpoint, 0);
        return serviceEndpoint;
    }

    public void unregisterInternalEndpoint(ComponentContext provider, InternalEndpoint serviceEndpoint) {
        if (serviceEndpoint.isClustered()) {
            serviceEndpoint.setComponentName(null);
        } else {
            String key = this.getKey(serviceEndpoint);
            this.internalEndpoints.remove(key);
            this.unregisterEndpoint(key);
        }
        this.fireEvent(serviceEndpoint, 1);
    }

    protected void retrieveInterfaceFromSUDescriptor(InternalEndpoint serviceEndpoint) {
        ServiceUnitLifeCycle[] sus = this.registry.getDeployedServiceUnits(serviceEndpoint.getComponentNameSpace().getName());
        for (int i = 0; i < sus.length; ++i) {
            Provides[] provides;
            Services services = sus[i].getServices();
            if (services == null || (provides = services.getProvides()) == null) continue;
            for (int j = 0; j < provides.length; ++j) {
                if (provides[j].getInterfaceName() == null || !serviceEndpoint.getServiceName().equals(provides[j].getServiceName()) || !serviceEndpoint.getEndpointName().equals(provides[j].getEndpointName())) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Endpoint " + serviceEndpoint + " is provided by SU " + sus[i].getName()));
                    logger.debug((Object)("Endpoint " + serviceEndpoint + " implements interface " + provides[j].getInterfaceName()));
                }
                serviceEndpoint.addInterface(provides[j].getInterfaceName());
            }
        }
    }

    protected void retrieveInterfacesFromDescription(InternalEndpoint serviceEndpoint) {
        block12: {
            try {
                Document document = this.registry.getEndpointDescriptor(serviceEndpoint);
                if (document == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Endpoint " + serviceEndpoint + " has no service description"));
                    }
                    return;
                }
                Definition definition = WSDLFactory.newInstance().newWSDLReader().readWSDL(null, document);
                if (definition.getPortTypes().keySet().size() == 1 && definition.getServices().keySet().size() == 0) {
                    PortType portType = (PortType)definition.getPortTypes().values().iterator().next();
                    QName interfaceName = portType.getQName();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Endpoint " + serviceEndpoint + " implements interface " + interfaceName));
                    }
                    serviceEndpoint.addInterface(interfaceName);
                } else {
                    Service service = definition.getService(serviceEndpoint.getServiceName());
                    if (service == null) {
                        logger.info((Object)("Endpoint " + serviceEndpoint + " has a service description, but no matching service found in " + definition.getServices().keySet()));
                        return;
                    }
                    Port port = service.getPort(serviceEndpoint.getEndpointName());
                    if (port == null) {
                        logger.info((Object)("Endpoint " + serviceEndpoint + " has a service description, but no matching endpoint found in " + service.getPorts().keySet()));
                        return;
                    }
                    if (port.getBinding() == null) {
                        logger.info((Object)("Endpoint " + serviceEndpoint + " has a service description, but no binding found"));
                        return;
                    }
                    if (port.getBinding().getPortType() == null) {
                        logger.info((Object)("Endpoint " + serviceEndpoint + " has a service description, but no port type found"));
                        return;
                    }
                    QName interfaceName = port.getBinding().getPortType().getQName();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Endpoint " + serviceEndpoint + " implements interface " + interfaceName));
                    }
                    serviceEndpoint.addInterface(interfaceName);
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Error retrieving interfaces from service description: " + e.getMessage()));
                if (!logger.isDebugEnabled()) break block12;
                logger.debug((Object)"Error retrieving interfaces from service description", (Throwable)e);
            }
        }
    }

    public void registerRemoteEndpoint(InternalEndpoint remote) {
        InternalEndpoint endpoint = (InternalEndpoint)this.internalEndpoints.get(this.getKey(remote));
        if (endpoint == null) {
            endpoint = new InternalEndpoint(null, remote.getEndpointName(), remote.getServiceName());
            this.internalEndpoints.put(this.getKey(endpoint), endpoint);
        }
        endpoint.addRemoteEndpoint(remote);
        this.fireEvent(remote, 6);
    }

    public void unregisterRemoteEndpoint(InternalEndpoint remote) {
        InternalEndpoint endpoint = (InternalEndpoint)this.internalEndpoints.get(this.getKey(remote));
        if (endpoint != null) {
            endpoint.removeRemoteEndpoint(remote);
            this.fireEvent(remote, 7);
        }
    }

    public ServiceEndpoint getEndpoint(QName service, String name) {
        String key = this.getKey(service, name);
        ServiceEndpoint ep = (ServiceEndpoint)this.linkedEndpoints.get(key);
        if (ep == null) {
            ep = (ServiceEndpoint)this.internalEndpoints.get(key);
        }
        return ep;
    }

    public ServiceEndpoint getInternalEndpoint(QName service, String name) {
        return (ServiceEndpoint)this.internalEndpoints.get(this.getKey(service, name));
    }

    public void registerExternalEndpoint(ComponentNameSpace cns, ServiceEndpoint externalEndpoint) throws JBIException {
        ExternalEndpoint serviceEndpoint = new ExternalEndpoint(cns, externalEndpoint);
        if (this.externalEndpoints.get(this.getKey(serviceEndpoint)) != null) {
            throw new JBIException("An external endpoint for service " + externalEndpoint.getServiceName() + " and endpoint " + externalEndpoint.getEndpointName() + " is already registered");
        }
        this.registerEndpoint(serviceEndpoint);
        this.externalEndpoints.put(this.getKey(serviceEndpoint), serviceEndpoint);
        this.fireEvent(serviceEndpoint, 2);
    }

    public void unregisterExternalEndpoint(ComponentNameSpace cns, ServiceEndpoint externalEndpoint) {
        this.externalEndpoints.remove(this.getKey(externalEndpoint));
        this.unregisterEndpoint(this.getKey(externalEndpoint));
        this.fireEvent(externalEndpoint, 3);
    }

    public ServiceEndpoint[] getExternalEndpointsForInterface(QName interfaceName) {
        Collection endpoints = this.getEndpointsByInterface(interfaceName, this.getExternalEndpoints());
        return this.asEndpointArray(endpoints);
    }

    public ServiceEndpoint[] getExternalEndpointsForService(QName serviceName) {
        Collection endpoints = this.getEndpointsByService(serviceName, this.getExternalEndpoints());
        return this.asEndpointArray(endpoints);
    }

    protected ServiceEndpoint[] asEndpointArray(Collection collection) {
        if (collection == null) {
            return new ServiceEndpoint[0];
        }
        ServiceEndpoint[] answer = new ServiceEndpoint[collection.size()];
        answer = collection.toArray(answer);
        return answer;
    }

    protected Collection getEndpointsByService(QName serviceName, Collection endpoints) {
        ArrayList<ServiceEndpoint> answer = new ArrayList<ServiceEndpoint>();
        Iterator i = endpoints.iterator();
        while (i.hasNext()) {
            ServiceEndpoint endpoint = (ServiceEndpoint)i.next();
            if (!endpoint.getServiceName().equals(serviceName)) continue;
            answer.add(endpoint);
        }
        return answer;
    }

    protected Collection getEndpointsByInterface(QName interfaceName, Collection endpoints) {
        if (interfaceName == null) {
            return endpoints;
        }
        HashSet<ServiceEndpoint> answer = new HashSet<ServiceEndpoint>();
        Iterator i = endpoints.iterator();
        block0: while (i.hasNext()) {
            ServiceEndpoint endpoint = (ServiceEndpoint)i.next();
            QName[] interfaces = endpoint.getInterfaces();
            if (interfaces == null) continue;
            for (int k = 0; k < interfaces.length; ++k) {
                QName qn = interfaces[k];
                if (qn == null || !qn.equals(interfaceName)) continue;
                answer.add(endpoint);
                continue block0;
            }
        }
        return answer;
    }

    protected Collection getInternalEndpoints() {
        return this.internalEndpoints.values();
    }

    protected Collection getExternalEndpoints() {
        return this.externalEndpoints.values();
    }

    public void registerEndpointConnection(QName fromSvc, String fromEp, QName toSvc, String toEp, String link) throws JBIException {
        LinkedEndpoint ep = new LinkedEndpoint(fromSvc, fromEp, toSvc, toEp, link);
        if (this.linkedEndpoints.get(this.getKey(ep)) != null) {
            throw new JBIException("An endpoint connection for service " + ep.getServiceName() + " and name " + ep.getEndpointName() + " is already registered");
        }
        this.linkedEndpoints.put(this.getKey(ep), ep);
        this.registerEndpoint(ep);
        this.fireEvent(ep, 4);
    }

    public void unregisterEndpointConnection(QName fromSvc, String fromEp) {
        this.unregisterEndpoint(this.getKey(fromSvc, fromEp));
        LinkedEndpoint ep = (LinkedEndpoint)this.linkedEndpoints.remove(this.getKey(fromSvc, fromEp));
        this.fireEvent(ep, 5);
    }

    public void registerInterfaceConnection(QName fromItf, QName toSvc, String toEp) throws JBIException {
        if (this.interfaceConnections.get(fromItf) != null) {
            throw new JBIException("An interface connection for " + fromItf + " is already registered");
        }
        this.interfaceConnections.put(fromItf, new InterfaceConnection(toSvc, toEp));
    }

    public void unregisterInterfaceConnection(QName fromItf) {
        this.interfaceConnections.remove(fromItf);
    }

    private void registerEndpoint(AbstractServiceEndpoint serviceEndpoint) {
        String key = this.getKey(serviceEndpoint);
        try {
            Endpoint endpoint = new Endpoint(serviceEndpoint, this.registry);
            ObjectName objectName = this.registry.getContainer().getManagementContext().createObjectName(endpoint);
            this.registry.getContainer().getManagementContext().registerMBean(objectName, endpoint, EndpointMBean.class);
            this.endpointMBeans.put(key, endpoint);
        }
        catch (JMException e) {
            logger.error((Object)"Could not register MBean for endpoint", (Throwable)e);
        }
    }

    private void unregisterEndpoint(String key) {
        Endpoint ep = (Endpoint)this.endpointMBeans.remove(key);
        if (ep != null) {
            try {
                this.registry.getContainer().getManagementContext().unregisterMBean(ep);
            }
            catch (JBIException e) {
                logger.error((Object)"Could not unregister MBean for endpoint", (Throwable)e);
            }
        }
    }

    private String getKey(ServiceEndpoint ep) {
        return this.getKey(ep.getServiceName(), ep.getEndpointName());
    }

    private String getKey(QName svcName, String epName) {
        return svcName + epName;
    }

    protected void fireEvent(ServiceEndpoint ep, int type) {
        EndpointEvent event = new EndpointEvent(ep, type);
        EndpointListener[] listeners = (EndpointListener[])this.registry.getContainer().getListeners(EndpointListener.class);
        block10: for (int i = 0; i < listeners.length; ++i) {
            switch (type) {
                case 0: {
                    listeners[i].internalEndpointRegistered(event);
                    continue block10;
                }
                case 1: {
                    listeners[i].internalEndpointUnregistered(event);
                    continue block10;
                }
                case 2: {
                    listeners[i].externalEndpointRegistered(event);
                    continue block10;
                }
                case 3: {
                    listeners[i].externalEndpointUnregistered(event);
                    continue block10;
                }
                case 4: {
                    listeners[i].linkedEndpointRegistered(event);
                    continue block10;
                }
                case 5: {
                    listeners[i].linkedEndpointUnregistered(event);
                    continue block10;
                }
                case 6: {
                    listeners[i].remoteEndpointRegistered(event);
                    continue block10;
                }
                case 7: {
                    listeners[i].remoteEndpointUnregistered(event);
                }
            }
        }
    }

    private static class InterfaceConnection {
        QName service;
        String endpoint;

        InterfaceConnection(QName service, String endpoint) {
            this.service = service;
            this.endpoint = endpoint;
        }
    }
}

