/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.DeploymentException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.container.ActivationSpec;
import org.apache.servicemix.jbi.container.EnvironmentContext;
import org.apache.servicemix.jbi.container.ServiceAssemblyEnvironment;
import org.apache.servicemix.jbi.container.SubscriptionSpec;
import org.apache.servicemix.jbi.deployment.ServiceAssembly;
import org.apache.servicemix.jbi.deployment.ServiceUnit;
import org.apache.servicemix.jbi.framework.ComponentContextImpl;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.framework.ComponentNameSpace;
import org.apache.servicemix.jbi.framework.ComponentRegistry;
import org.apache.servicemix.jbi.framework.EndpointRegistry;
import org.apache.servicemix.jbi.framework.RegistryMBean;
import org.apache.servicemix.jbi.framework.ServiceAssemblyLifeCycle;
import org.apache.servicemix.jbi.framework.ServiceAssemblyRegistry;
import org.apache.servicemix.jbi.framework.ServiceUnitLifeCycle;
import org.apache.servicemix.jbi.framework.ServiceUnitMBean;
import org.apache.servicemix.jbi.framework.SharedLibrary;
import org.apache.servicemix.jbi.framework.SharedLibraryMBean;
import org.apache.servicemix.jbi.framework.SubscriptionRegistry;
import org.apache.servicemix.jbi.management.BaseSystemService;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.servicedesc.AbstractServiceEndpoint;
import org.apache.servicemix.jbi.servicedesc.DynamicEndpoint;
import org.apache.servicemix.jbi.servicedesc.InternalEndpoint;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Registry
extends BaseSystemService
implements RegistryMBean {
    private static final Log log = LogFactory.getLog((Class)Registry.class);
    private ComponentRegistry componentRegistry = new ComponentRegistry(this);
    private EndpointRegistry endpointRegistry = new EndpointRegistry(this);
    private SubscriptionRegistry subscriptionRegistry = new SubscriptionRegistry(this);
    private ServiceAssemblyRegistry serviceAssemblyRegistry = new ServiceAssemblyRegistry(this);
    private Map sharedLibraries;
    private Map serviceUnits = new ConcurrentHashMap();
    private List pendingAssemblies = new CopyOnWriteArrayList();
    private List pendingComponents;

    public Registry() {
        this.sharedLibraries = new ConcurrentHashMap();
        this.pendingComponents = new CopyOnWriteArrayList();
    }

    public String getDescription() {
        return "Registry of Components/SU's and Endpoints";
    }

    protected Class getServiceMBean() {
        return RegistryMBean.class;
    }

    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    public EndpointRegistry getEndpointRegistry() {
        return this.endpointRegistry;
    }

    public void start() throws JBIException {
        this.componentRegistry.start();
        this.serviceAssemblyRegistry.start();
        super.start();
    }

    public void stop() throws JBIException {
        this.serviceAssemblyRegistry.stop();
        this.componentRegistry.stop();
        super.stop();
    }

    public void shutDown() throws JBIException {
        this.serviceAssemblyRegistry.shutDown();
        this.componentRegistry.shutDown();
        super.shutDown();
        this.container.getManagementContext().unregisterMBean(this);
    }

    protected EnvironmentContext getEnvironmentContext() {
        return this.container.getEnvironmentContext();
    }

    protected boolean isContainerEmbedded() {
        return this.container.isEmbedded();
    }

    protected InternalEndpoint matchEndpointByName(ServiceEndpoint[] endpoints, String endpointName) {
        InternalEndpoint result = null;
        if (endpoints != null && endpointName != null && endpointName.length() > 0) {
            for (int i = 0; i < endpoints.length; ++i) {
                if (!endpoints[i].getEndpointName().equals(endpointName)) continue;
                result = (InternalEndpoint)endpoints[i];
                break;
            }
        }
        return result;
    }

    public ServiceEndpoint activateEndpoint(ComponentContextImpl context, QName serviceName, String endpointName) throws JBIException {
        InternalEndpoint result = this.endpointRegistry.registerInternalEndpoint(context, serviceName, endpointName);
        return result;
    }

    public ServiceEndpoint[] getEndpointsForComponent(ComponentNameSpace cns) {
        return this.endpointRegistry.getEndpointsForComponent(cns);
    }

    public ServiceEndpoint[] getEndpointsForInterface(QName interfaceName) {
        return this.endpointRegistry.getEndpointsForInterface(interfaceName);
    }

    public void deactivateEndpoint(ComponentContext provider, InternalEndpoint serviceEndpoint) {
        this.endpointRegistry.unregisterInternalEndpoint(provider, serviceEndpoint);
    }

    public Document getEndpointDescriptor(ServiceEndpoint endpoint) throws JBIException {
        if (!(endpoint instanceof AbstractServiceEndpoint)) {
            throw new JBIException("Descriptors can not be queried for external endpoints");
        }
        AbstractServiceEndpoint se = (AbstractServiceEndpoint)endpoint;
        ComponentMBeanImpl component = this.getComponent(se.getComponentNameSpace());
        return component.getComponent().getServiceDescription(endpoint);
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
        Collection connectors = this.getComponents();
        Iterator iter = connectors.iterator();
        while (iter.hasNext()) {
            ComponentMBeanImpl connector = (ComponentMBeanImpl)iter.next();
            ServiceEndpoint se = connector.getComponent().resolveEndpointReference(epr);
            if (se == null) continue;
            return new DynamicEndpoint(connector.getComponentNameSpace(), se, epr);
        }
        return this.resolveStandardEPR(epr);
    }

    public ServiceEndpoint resolveStandardEPR(DocumentFragment epr) {
        try {
            Element elem;
            NodeList nl;
            Node child;
            if (epr.getChildNodes().getLength() == 1 && (child = epr.getFirstChild()) instanceof Element && (nl = (elem = (Element)child).getElementsByTagNameNS("http://www.w3.org/2005/08/addressing", "Address")).getLength() == 1) {
                Element address = (Element)nl.item(0);
                String uri = DOMUtil.getElementText(address);
                if (uri != null) {
                    uri = uri.trim();
                }
                if (uri.startsWith("endpoint:")) {
                    uri = uri.substring("endpoint:".length());
                    String[] parts = this.split(uri);
                    return this.getInternalEndpoint(new QName(parts[0], parts[1]), parts[2]);
                }
                if (uri.startsWith("service:")) {
                    uri = uri.substring("service:".length());
                    String[] parts = this.splitService(uri);
                    return this.getEndpoint(new QName(parts[0], parts[1]), parts[1]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected String[] splitService(String uri) {
        int sep = (uri = uri.trim()).indexOf(47) > 0 ? 47 : 58;
        int idx1 = uri.lastIndexOf(sep);
        String svcName = uri.substring(idx1 + 1);
        String nsUri = uri.substring(0, idx1);
        return new String[]{nsUri, svcName};
    }

    protected String[] split(String uri) {
        int sep = (uri = uri.trim()).indexOf(47) > 0 ? 47 : 58;
        int idx1 = uri.lastIndexOf(sep);
        int idx2 = uri.lastIndexOf(sep, idx1 - 1);
        String epName = uri.substring(idx1 + 1);
        String svcName = uri.substring(idx2 + 1, idx1);
        String nsUri = uri.substring(0, idx2);
        return new String[]{nsUri, svcName, epName};
    }

    public void registerExternalEndpoint(ComponentNameSpace cns, ServiceEndpoint externalEndpoint) throws JBIException {
        if (externalEndpoint != null) {
            this.endpointRegistry.registerExternalEndpoint(cns, externalEndpoint);
        }
    }

    public void deregisterExternalEndpoint(ComponentNameSpace cns, ServiceEndpoint externalEndpoint) {
        this.endpointRegistry.unregisterExternalEndpoint(cns, externalEndpoint);
    }

    public ServiceEndpoint getEndpoint(QName service, String name) {
        return this.endpointRegistry.getEndpoint(service, name);
    }

    public ServiceEndpoint getInternalEndpoint(QName service, String name) {
        return this.endpointRegistry.getInternalEndpoint(service, name);
    }

    public ServiceEndpoint[] getEndpointsForService(QName serviceName) {
        return this.endpointRegistry.getEndpointsForService(serviceName);
    }

    public ServiceEndpoint[] getExternalEndpoints(QName interfaceName) {
        return this.endpointRegistry.getExternalEndpointsForInterface(interfaceName);
    }

    public ServiceEndpoint[] getExternalEndpointsForService(QName serviceName) {
        return this.endpointRegistry.getExternalEndpointsForService(serviceName);
    }

    public ComponentMBeanImpl registerComponent(ComponentNameSpace name, String description, Component component, boolean binding, boolean service, String[] sharedLibraries) throws JBIException {
        return this.componentRegistry.registerComponent(name, description, component, binding, service, sharedLibraries);
    }

    public void deregisterComponent(ComponentMBeanImpl component) {
        this.componentRegistry.deregisterComponent(component);
    }

    public Collection getComponents() {
        return this.componentRegistry.getComponents();
    }

    public ComponentMBeanImpl getComponent(ComponentNameSpace cns) {
        return this.componentRegistry.getComponent(cns);
    }

    public ComponentMBeanImpl getComponent(String name) {
        ComponentNameSpace cns = new ComponentNameSpace(this.container.getName(), name);
        return this.getComponent(cns);
    }

    public ObjectName[] getEngineComponents() {
        ObjectName[] result = null;
        ArrayList<ObjectName> tmpList = new ArrayList<ObjectName>();
        Iterator i = this.getComponents().iterator();
        while (i.hasNext()) {
            ComponentMBeanImpl lcc = (ComponentMBeanImpl)i.next();
            if (lcc.isPojo() || !lcc.isService() || lcc.getMBeanName() == null) continue;
            tmpList.add(lcc.getMBeanName());
        }
        result = new ObjectName[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    public ObjectName[] getBindingComponents() {
        ObjectName[] result = null;
        ArrayList<ObjectName> tmpList = new ArrayList<ObjectName>();
        Iterator i = this.getComponents().iterator();
        while (i.hasNext()) {
            ComponentMBeanImpl lcc = (ComponentMBeanImpl)i.next();
            if (lcc.isPojo() || !lcc.isBinding() || lcc.getMBeanName() == null) continue;
            tmpList.add(lcc.getMBeanName());
        }
        result = new ObjectName[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    public ObjectName[] getPojoComponents() {
        ObjectName[] result = null;
        ArrayList<ObjectName> tmpList = new ArrayList<ObjectName>();
        Iterator i = this.getComponents().iterator();
        while (i.hasNext()) {
            ComponentMBeanImpl lcc = (ComponentMBeanImpl)i.next();
            if (!lcc.isPojo() || lcc.getMBeanName() == null) continue;
            tmpList.add(lcc.getMBeanName());
        }
        result = new ObjectName[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    public void registerSubscriptions(ComponentContextImpl context, ActivationSpec as) {
        QName service = as.getService();
        String endpointName = as.getEndpoint();
        InternalEndpoint endpoint = new InternalEndpoint(context.getComponentNameSpace(), endpointName, service);
        SubscriptionSpec[] specs = as.getSubscriptions();
        if (specs != null) {
            for (int i = 0; i < specs.length; ++i) {
                this.registerSubscription(context, specs[i], endpoint);
            }
        }
    }

    public void deregisterSubscriptions(ComponentContextImpl context, ActivationSpec as) {
        SubscriptionSpec[] specs = as.getSubscriptions();
        if (specs != null) {
            for (int i = 0; i < specs.length; ++i) {
                this.deregisterSubscription(context, specs[i]);
            }
        }
    }

    public void registerSubscription(ComponentContextImpl context, SubscriptionSpec subscription, ServiceEndpoint endpoint) {
        InternalEndpoint sei = (InternalEndpoint)endpoint;
        subscription.setName(context.getComponentNameSpace());
        this.subscriptionRegistry.registerSubscription(subscription, sei);
    }

    public InternalEndpoint deregisterSubscription(ComponentContextImpl context, SubscriptionSpec subscription) {
        subscription.setName(context.getComponentNameSpace());
        InternalEndpoint result = this.subscriptionRegistry.deregisterSubscription(subscription);
        return result;
    }

    public List getMatchingSubscriptionEndpoints(MessageExchangeImpl exchange) {
        return this.subscriptionRegistry.getMatchingSubscriptionEndpoints(exchange);
    }

    public ServiceAssemblyLifeCycle registerServiceAssembly(ServiceAssembly sa, ServiceAssemblyEnvironment env) throws DeploymentException {
        return this.serviceAssemblyRegistry.register(sa, env);
    }

    public ServiceAssemblyLifeCycle registerServiceAssembly(ServiceAssembly sa, String[] suKeys, ServiceAssemblyEnvironment env) throws DeploymentException {
        return this.serviceAssemblyRegistry.register(sa, suKeys, env);
    }

    public boolean unregisterServiceAssembly(String saName) {
        return this.serviceAssemblyRegistry.unregister(saName);
    }

    public ServiceAssemblyLifeCycle getServiceAssembly(String saName) {
        return this.serviceAssemblyRegistry.getServiceAssembly(saName);
    }

    public ServiceUnitLifeCycle[] getDeployedServiceUnits(String componentName) {
        Collection sus = this.serviceUnits.values();
        ArrayList<ServiceUnitLifeCycle> tmpList = new ArrayList<ServiceUnitLifeCycle>();
        Iterator iter = sus.iterator();
        while (iter.hasNext()) {
            ServiceUnitLifeCycle su = (ServiceUnitLifeCycle)iter.next();
            if (!su.getComponentName().equals(componentName)) continue;
            tmpList.add(su);
        }
        ServiceUnitLifeCycle[] result = new ServiceUnitLifeCycle[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    public String[] getDeployedServiceAssemblies() {
        return this.serviceAssemblyRegistry.getDeployedServiceAssemblies();
    }

    public String[] getDeployedServiceAssembliesForComponent(String componentName) {
        return this.serviceAssemblyRegistry.getDeployedServiceAssembliesForComponent(componentName);
    }

    public String[] getComponentsForDeployedServiceAssembly(String saName) {
        return this.serviceAssemblyRegistry.getComponentsForDeployedServiceAssembly(saName);
    }

    public boolean isSADeployedServiceUnit(String componentName, String suName) {
        return this.serviceAssemblyRegistry.isDeployedServiceUnit(componentName, suName);
    }

    public ServiceUnitLifeCycle getServiceUnit(String suKey) {
        return (ServiceUnitLifeCycle)this.serviceUnits.get(suKey);
    }

    public String registerServiceUnit(ServiceUnit su, String saName, File suDir) {
        ServiceUnitLifeCycle sulc = new ServiceUnitLifeCycle(su, saName, this, suDir);
        this.serviceUnits.put(sulc.getKey(), sulc);
        try {
            ObjectName objectName = this.getContainer().getManagementContext().createObjectName(sulc);
            this.getContainer().getManagementContext().registerMBean(objectName, sulc, ServiceUnitMBean.class);
        }
        catch (JMException e) {
            log.error((Object)"Could not register MBean for service unit", (Throwable)e);
        }
        return sulc.getKey();
    }

    public void unregisterServiceUnit(String suKey) {
        ServiceUnitLifeCycle sulc = (ServiceUnitLifeCycle)this.serviceUnits.remove(suKey);
        if (sulc != null) {
            try {
                this.getContainer().getManagementContext().unregisterMBean(sulc);
            }
            catch (JBIException e) {
                log.error((Object)"Could not unregister MBean for service unit", (Throwable)e);
            }
        }
    }

    public void registerSharedLibrary(org.apache.servicemix.jbi.deployment.SharedLibrary sl, File installationDir) {
        SharedLibrary library = new SharedLibrary(sl, installationDir);
        this.sharedLibraries.put(library.getName(), library);
        try {
            ObjectName objectName = this.getContainer().getManagementContext().createObjectName(library);
            this.getContainer().getManagementContext().registerMBean(objectName, library, SharedLibraryMBean.class);
        }
        catch (JMException e) {
            log.error((Object)"Could not register MBean for service unit", (Throwable)e);
        }
        this.checkPendingComponents();
    }

    public void unregisterSharedLibrary(String name) {
        SharedLibrary sl = (SharedLibrary)this.sharedLibraries.remove(name);
        if (sl != null) {
            try {
                this.getContainer().getManagementContext().unregisterMBean(sl);
            }
            catch (JBIException e) {
                log.error((Object)"Could not unregister MBean for shared library", (Throwable)e);
            }
        }
    }

    public SharedLibrary getSharedLibrary(String name) {
        return (SharedLibrary)this.sharedLibraries.get(name);
    }

    public Collection getSharedLibraries() {
        return this.sharedLibraries.values();
    }

    public void registerEndpointConnection(QName fromSvc, String fromEp, QName toSvc, String toEp, String link) throws JBIException {
        this.endpointRegistry.registerEndpointConnection(fromSvc, fromEp, toSvc, toEp, link);
    }

    public void unregisterEndpointConnection(QName fromSvc, String fromEp) {
        this.endpointRegistry.unregisterEndpointConnection(fromSvc, fromEp);
    }

    public void registerInterfaceConnection(QName fromItf, QName toSvc, String toEp) throws JBIException {
        this.endpointRegistry.registerInterfaceConnection(fromItf, toSvc, toEp);
    }

    public void unregisterInterfaceConnection(QName fromItf) {
        this.endpointRegistry.unregisterInterfaceConnection(fromItf);
    }

    public void registerRemoteEndpoint(ServiceEndpoint endpoint) {
        this.endpointRegistry.registerRemoteEndpoint((InternalEndpoint)endpoint);
    }

    public void unregisterRemoteEndpoint(ServiceEndpoint endpoint) {
        this.endpointRegistry.unregisterRemoteEndpoint((InternalEndpoint)endpoint);
    }

    public void checkPendingAssemblies() {
        try {
            this.getContainer().getWorkManager().scheduleWork(new Work(){

                public void release() {
                }

                public void run() {
                    Registry.this.startPendingAssemblies();
                }
            });
        }
        catch (WorkException e) {
            log.error((Object)"Could not schedule work", (Throwable)e);
        }
    }

    public void addPendingAssembly(ServiceAssemblyLifeCycle sa) {
        if (!this.pendingAssemblies.contains(sa)) {
            this.pendingAssemblies.add(sa);
        }
    }

    protected synchronized void startPendingAssemblies() {
        Iterator iter = this.pendingAssemblies.iterator();
        while (iter.hasNext()) {
            ServiceAssemblyLifeCycle sa = (ServiceAssemblyLifeCycle)iter.next();
            ServiceUnitLifeCycle[] sus = sa.getDeployedSUs();
            boolean ok = true;
            for (int i = 0; i < sus.length; ++i) {
                ComponentMBeanImpl c = this.getComponent(sus[i].getComponentName());
                if (c != null && c.isStarted()) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            try {
                sa.restore();
                this.pendingAssemblies.remove(sa);
            }
            catch (Exception e) {
                log.error((Object)"Error trying to restore service assembly state", (Throwable)e);
            }
        }
    }

    public void checkPendingComponents() {
        try {
            this.getContainer().getWorkManager().scheduleWork(new Work(){

                public void release() {
                }

                public void run() {
                    Registry.this.startPendingComponents();
                }
            });
        }
        catch (WorkException e) {
            log.error((Object)"Could not schedule work", (Throwable)e);
        }
    }

    public void addPendingComponent(ComponentMBeanImpl comp) {
        if (!this.pendingComponents.contains(comp)) {
            this.pendingComponents.add(comp);
        }
    }

    protected synchronized void startPendingComponents() {
        Iterator iter = this.pendingComponents.iterator();
        while (iter.hasNext()) {
            ComponentMBeanImpl componentMBeanImpl = (ComponentMBeanImpl)iter.next();
        }
    }
}

