/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.jaxp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import org.apache.servicemix.jbi.jaxp.ExtendedNamespaceContext;

public class ExtendedXMLStreamReader
extends StreamReaderDelegate {
    private SimpleNamespaceContext context = new SimpleNamespaceContext();

    public ExtendedXMLStreamReader(XMLStreamReader delegate) {
        super(delegate);
    }

    public NamespaceContext getNamespaceContext() {
        return this.context;
    }

    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    public int next() throws XMLStreamException {
        int next = super.next();
        if (next == 1) {
            this.context = new SimpleNamespaceContext(this.context, this.getNamespaces());
        } else if (next == 2) {
            this.context = this.context.getParent();
        }
        return next;
    }

    private Map getNamespaces() {
        HashMap<String, String> ns = new HashMap<String, String>();
        for (int i = 0; i < this.getNamespaceCount(); ++i) {
            ns.put(this.getNamespacePrefix(i), this.getNamespaceURI(i));
        }
        return ns;
    }

    public static class SimpleNamespaceContext
    implements ExtendedNamespaceContext {
        private SimpleNamespaceContext parent;
        private Map namespaces;

        public SimpleNamespaceContext() {
            this.namespaces = new HashMap();
        }

        public SimpleNamespaceContext(SimpleNamespaceContext parent, Map namespaces) {
            this.parent = parent;
            this.namespaces = namespaces;
        }

        public SimpleNamespaceContext getParent() {
            return this.parent;
        }

        public Iterator getPrefixes() {
            HashSet prefixes = new HashSet();
            SimpleNamespaceContext context = this;
            while (context != null) {
                prefixes.addAll(context.namespaces.keySet());
                context = context.parent;
            }
            return prefixes.iterator();
        }

        public String getNamespaceURI(String prefix) {
            String uri = (String)this.namespaces.get(prefix);
            if (uri == null && this.parent != null) {
                uri = this.parent.getNamespaceURI(prefix);
            }
            return uri;
        }

        public String getPrefix(String namespaceURI) {
            SimpleNamespaceContext context = this;
            while (context != null) {
                Iterator it = context.namespaces.keySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    if (!entry.getValue().equals(namespaceURI)) continue;
                    return (String)entry.getKey();
                }
                context = context.parent;
            }
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            HashSet prefixes = new HashSet();
            SimpleNamespaceContext context = this;
            while (context != null) {
                Iterator it = context.namespaces.keySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    if (!entry.getValue().equals(namespaceURI)) continue;
                    prefixes.add(entry.getKey());
                }
                context = context.parent;
            }
            return prefixes.iterator();
        }
    }
}

