/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.jaxp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.jaxp.BytesSource;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.xalan.xsltc.trax.DOM2SAX;
import org.apache.xalan.xsltc.trax.SAX2DOM;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SourceTransformer {
    public static final String CONTENT_DOCUMENT_PROPERTY = "org.apache.servicemix.content.document";
    private static final transient Log log = LogFactory.getLog((Class)SourceTransformer.class);
    private DocumentBuilderFactory documentBuilderFactory;
    private TransformerFactory transformerFactory;
    public static final String defaultCharEncodingName = "UTF-8";

    public SourceTransformer() {
    }

    public SourceTransformer(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public void toResult(Source source, Result result) throws TransformerException {
        Transformer transformer = this.createTransfomer();
        if (transformer == null) {
            throw new TransformerException("Could not create a transformer - JAXP is misconfigured!");
        }
        if (source != null) {
            transformer.transform(source, result);
        } else {
            log.warn((Object)"No Source available");
        }
    }

    public String toString(Source source) throws TransformerException {
        if (source == null) {
            return null;
        }
        if (source instanceof StringSource) {
            return ((StringSource)source).getText();
        }
        if (source instanceof BytesSource) {
            return new String(((BytesSource)source).getData());
        }
        StringWriter buffer = new StringWriter();
        this.toResult(source, new StreamResult(buffer));
        return buffer.toString();
    }

    public String toString(Node node) throws TransformerException {
        return this.toString(new DOMSource(node));
    }

    public String contentToString(NormalizedMessage message) throws MessagingException, TransformerException, ParserConfigurationException, IOException, SAXException {
        return this.toString(message.getContent());
    }

    public DOMSource toDOMSource(Source source) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        if (source instanceof DOMSource) {
            return (DOMSource)source;
        }
        if (source instanceof SAXSource) {
            return this.toDOMSourceFromSAX((SAXSource)source);
        }
        if (source instanceof StreamSource) {
            return this.toDOMSourceFromStream((StreamSource)source);
        }
        return null;
    }

    public Source toDOMSource(NormalizedMessage message) throws MessagingException, TransformerException, ParserConfigurationException, IOException, SAXException {
        Node node = this.toDOMNode(message);
        return new DOMSource(node);
    }

    public SAXSource toSAXSource(Source source) throws IOException, SAXException {
        if (source instanceof SAXSource) {
            return (SAXSource)source;
        }
        if (source instanceof DOMSource) {
            return this.toSAXSourceFromDOM((DOMSource)source);
        }
        if (source instanceof StreamSource) {
            return this.toSAXSourceFromStream((StreamSource)source);
        }
        return null;
    }

    public StreamSource toStreamSource(Source source) throws TransformerException {
        if (source instanceof StreamSource) {
            return (StreamSource)source;
        }
        if (source instanceof DOMSource) {
            return this.toStreamSourceFromDOM((DOMSource)source);
        }
        if (source instanceof SAXSource) {
            return this.toStreamSourceFromSAX((SAXSource)source);
        }
        return null;
    }

    public StreamSource toStreamSourceFromSAX(SAXSource source) throws TransformerException {
        InputSource inputSource = source.getInputSource();
        if (inputSource != null) {
            if (inputSource.getByteStream() != null) {
                return new StreamSource(inputSource.getByteStream());
            }
            if (inputSource.getCharacterStream() != null) {
                return new StreamSource(inputSource.getCharacterStream());
            }
        }
        String result = this.toString(source);
        return new StreamSource(new ByteArrayInputStream(result.getBytes()));
    }

    public StreamSource toStreamSourceFromDOM(DOMSource source) throws TransformerException {
        String result = this.toString(source);
        return new StreamSource(new ByteArrayInputStream(result.getBytes()));
    }

    public SAXSource toSAXSourceFromStream(StreamSource source) {
        InputSource inputSource = new InputSource(source.getInputStream());
        inputSource.setSystemId(source.getSystemId());
        inputSource.setPublicId(source.getPublicId());
        return new SAXSource(inputSource);
    }

    public Reader toReaderFromSource(Source src) throws TransformerException {
        StreamSource stSrc = this.toStreamSource(src);
        Reader r = stSrc.getReader();
        if (r == null) {
            r = new InputStreamReader(stSrc.getInputStream());
        }
        return r;
    }

    public DOMSource toDOMSourceFromStream(StreamSource source) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder builder = this.createDocumentBuilder();
        String systemId = source.getSystemId();
        Document document = null;
        InputStream inputStream = source.getInputStream();
        if (inputStream != null) {
            InputSource inputsource = new InputSource(inputStream);
            inputsource.setSystemId(systemId);
            inputsource.setEncoding(defaultCharEncodingName);
            document = builder.parse(inputsource);
        } else {
            Reader reader = source.getReader();
            if (reader != null) {
                document = builder.parse(new InputSource(reader));
            } else {
                throw new IOException("No input stream or reader available");
            }
        }
        return new DOMSource(document, systemId);
    }

    public SAXSource toSAXSourceFromDOM(DOMSource source) {
        DOM2SAX converter = new DOM2SAX(source.getNode());
        String systemId = converter.getSystemId();
        return new SAXSource((XMLReader)converter, new InputSource(systemId));
    }

    public DOMSource toDOMSourceFromSAX(SAXSource source) throws IOException, SAXException, ParserConfigurationException {
        return new DOMSource(this.toDOMNodeFromSAX(source));
    }

    public Node toDOMNodeFromSAX(SAXSource source) throws ParserConfigurationException, IOException, SAXException {
        SAX2DOM converter = new SAX2DOM((Node)this.createDocument());
        XMLReader xmlReader = source.getXMLReader();
        if (xmlReader == null) {
            xmlReader = this.createXMLReader();
        }
        xmlReader.setContentHandler((ContentHandler)converter);
        xmlReader.parse(source.getInputSource());
        return converter.getDOM();
    }

    private XMLReader createXMLReader() throws SAXException {
        try {
            return XMLReaderFactory.createXMLReader();
        }
        catch (Exception e) {
            return XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        }
    }

    public Node toDOMNode(Source source) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        return this.toDOMSource(source).getNode();
    }

    public Node toDOMNode(NormalizedMessage message) throws MessagingException, TransformerException, ParserConfigurationException, IOException, SAXException {
        Object value = message.getProperty(CONTENT_DOCUMENT_PROPERTY);
        if (value != null) {
            if (value instanceof Node) {
                return (Node)value;
            }
            throw new MessagingException("Invalid property type: Expected W3C DOM node but found: " + value.getClass().getName() + " with value: " + value);
        }
        Source content = message.getContent();
        if (content != null) {
            Node node = this.toDOMNode(content);
            message.setProperty(CONTENT_DOCUMENT_PROPERTY, (Object)node);
            return node;
        }
        return null;
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        if (this.documentBuilderFactory == null) {
            this.documentBuilderFactory = this.createDocumentBuilderFactory();
        }
        return this.documentBuilderFactory;
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        return factory;
    }

    public DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = this.getDocumentBuilderFactory();
        return factory.newDocumentBuilder();
    }

    public Document createDocument() throws ParserConfigurationException {
        DocumentBuilder builder = this.createDocumentBuilder();
        return builder.newDocument();
    }

    public TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = this.createTransformerFactory();
        }
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public Transformer createTransfomer() throws TransformerConfigurationException {
        TransformerFactory factory = this.getTransformerFactory();
        return factory.newTransformer();
    }

    public TransformerFactory createTransformerFactory() {
        TransformerFactory answer = TransformerFactory.newInstance();
        return answer;
    }
}

