/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.loaders;

import java.beans.Introspector;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;

public final class ClassLoaderUtil {
    private ClassLoaderUtil() {
    }

    public static void destroy(ClassLoader classLoader) {
        ClassLoaderUtil.releaseCommonsLoggingCache(classLoader);
        ClassLoaderUtil.clearSunSoftCache(ObjectInputStream.class, "subclassAudits");
        ClassLoaderUtil.clearSunSoftCache(ObjectOutputStream.class, "subclassAudits");
        ClassLoaderUtil.clearSunSoftCache(ObjectStreamClass.class, "localDescs");
        ClassLoaderUtil.clearSunSoftCache(ObjectStreamClass.class, "reflectors");
        Introspector.flushCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSunSoftCache(Class clazz, String fieldName) {
        Map cache = null;
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            cache = (Map)field.get(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cache != null) {
            Map map = cache;
            synchronized (map) {
                cache.clear();
            }
        }
    }

    public static void releaseCommonsLoggingCache(ClassLoader classLoader) {
        try {
            Class<?> logFactory = classLoader.loadClass("org.apache.commons.logging.LogFactory");
            Method release = logFactory.getMethod("release", ClassLoader.class);
            release.invoke(null, classLoader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

