/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.management;

import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.StandardMBean;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanNotificationBroadcaster;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.management.CachedAttribute;

public class BaseStandardMBean
extends StandardMBean
implements ModelMBeanNotificationBroadcaster,
MBeanRegistration,
PropertyChangeListener {
    private static final Log log = LogFactory.getLog((Class)BaseStandardMBean.class);
    private Map cachedAttributes = new LinkedHashMap();
    private PropertyUtilsBean beanUtil = new PropertyUtilsBean();
    private NotificationBroadcasterSupport broadcasterSupport = new NotificationBroadcasterSupport();
    protected ExecutorService executorService;
    private MBeanAttributeInfo[] attributeInfos;
    private MBeanInfo beanInfo;
    private ObjectName objectName;
    private MBeanServer beanServer;
    private static final Hashtable primitiveClasses = new Hashtable(8);

    public BaseStandardMBean(Object object, Class interfaceMBean, String description, MBeanAttributeInfo[] attrs, MBeanOperationInfo[] ops, ExecutorService executorService) throws ReflectionException, NotCompliantMBeanException {
        super(object, interfaceMBean);
        primitiveClasses.put(Boolean.TYPE.toString(), Boolean.TYPE);
        primitiveClasses.put(Character.TYPE.toString(), Character.TYPE);
        primitiveClasses.put(Byte.TYPE.toString(), Byte.TYPE);
        primitiveClasses.put(Short.TYPE.toString(), Short.TYPE);
        primitiveClasses.put(Integer.TYPE.toString(), Integer.TYPE);
        primitiveClasses.put(Long.TYPE.toString(), Long.TYPE);
        primitiveClasses.put(Float.TYPE.toString(), Float.TYPE);
        primitiveClasses.put(Double.TYPE.toString(), Double.TYPE);
        this.attributeInfos = attrs;
        this.buildAttributes(object, this.attributeInfos);
        this.beanInfo = new MBeanInfo(object.getClass().getName(), description, attrs, null, ops, this.getNotificationInfo());
        this.executorService = executorService;
    }

    public MBeanInfo getMBeanInfo() {
        return this.beanInfo;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public MBeanServer getBeanServer() {
        return this.beanServer;
    }

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object result = null;
        CachedAttribute ca = (CachedAttribute)this.cachedAttributes.get(name);
        if (ca == null) {
            Iterator i = this.cachedAttributes.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String key = entry.getKey().toString();
                if (!key.equalsIgnoreCase(name)) continue;
                ca = (CachedAttribute)entry.getValue();
                break;
            }
        }
        if (ca == null) {
            throw new AttributeNotFoundException("Could not locate " + name);
        }
        result = this.getCurrentValue(ca);
        return result;
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String name = attr.getName();
        CachedAttribute ca = (CachedAttribute)this.cachedAttributes.get(name);
        if (ca != null) {
            Attribute old = ca.getAttribute();
            try {
                ca.updateAttribute(this.beanUtil, attr);
                this.sendAttributeChangeNotification(old, attr);
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionException(e);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException(e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof Exception) {
                    throw new MBeanException(e);
                }
                throw new MBeanException(e);
            }
        } else {
            throw new AttributeNotFoundException("Could not locate " + name);
        }
    }

    public void updateAttribute(String name, Object value) {
        CachedAttribute ca = (CachedAttribute)this.cachedAttributes.get(name);
        if (ca != null) {
            Attribute old = ca.getAttribute();
            ca.updateAttributeValue(value);
            try {
                this.sendAttributeChangeNotification(old, ca.getAttribute());
            }
            catch (RuntimeOperationsException e) {
                log.error((Object)("Failed to update attribute: " + name + " to new value: " + value), (Throwable)e);
            }
            catch (MBeanException e) {
                log.error((Object)("Failed to update attribute: " + name + " to new value: " + value), (Throwable)e);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateAttribute(event.getPropertyName(), event.getNewValue());
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList result = null;
        try {
            if (attributes != null) {
                result = new AttributeList();
                for (int i = 0; i < attributes.length; ++i) {
                    CachedAttribute ca = (CachedAttribute)this.cachedAttributes.get(attributes[i]);
                    ca.updateValue(this.beanUtil);
                    result.add(ca.getAttribute());
                }
            } else {
                Iterator i = this.cachedAttributes.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    CachedAttribute ca = (CachedAttribute)entry.getValue();
                    ca.updateValue(this.beanUtil);
                    result.add(ca.getAttribute());
                }
            }
        }
        catch (MBeanException e) {
            log.error((Object)"Caught excdeption building attributes", (Throwable)e);
        }
        return result;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList result = new AttributeList();
        if (attributes != null) {
            for (int i = 0; i < attributes.size(); ++i) {
                Attribute attribute = (Attribute)attributes.get(i);
                try {
                    this.setAttribute(attribute);
                }
                catch (AttributeNotFoundException e) {
                    log.warn((Object)("Failed to setAttribute(" + attribute + ")"), (Throwable)e);
                }
                catch (InvalidAttributeValueException e) {
                    log.warn((Object)("Failed to setAttribute(" + attribute + ")"), (Throwable)e);
                }
                catch (MBeanException e) {
                    log.warn((Object)("Failed to setAttribute(" + attribute + ")"), (Throwable)e);
                }
                catch (ReflectionException e) {
                    log.warn((Object)("Failed to setAttribute(" + attribute + ")"), (Throwable)e);
                }
                result.add(attribute);
            }
        }
        return result;
    }

    public Object invoke(String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            Class[] parameterTypes = new Class[signature.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameterTypes[i] = (Class)primitiveClasses.get(signature[i]);
                if (parameterTypes[i] != null) continue;
                parameterTypes[i] = Class.forName(signature[i]);
            }
            return MethodUtils.invokeMethod((Object)this.getImplementation(), (String)name, (Object[])params, (Class[])parameterTypes);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw new MBeanException((Exception)t);
            }
            throw new MBeanException(e);
        }
    }

    public ObjectName preRegister(MBeanServer mbs, ObjectName on) throws Exception {
        if (mbs != null) {
            this.beanServer = mbs;
        }
        if (on != null) {
            this.objectName = on;
        }
        return on;
    }

    public void postRegister(Boolean done) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void sendNotification(final Notification notification) throws MBeanException, RuntimeOperationsException {
        if (notification != null && !this.executorService.isShutdown()) {
            this.executorService.execute(new Runnable(){

                public void run() {
                    BaseStandardMBean.this.broadcasterSupport.sendNotification(notification);
                }
            });
        }
    }

    public void sendNotification(String text) throws MBeanException, RuntimeOperationsException {
        if (text != null) {
            Notification myNtfyObj = new Notification("jmx.modelmbean.generic", (Object)this, 1L, text);
            this.sendNotification(myNtfyObj);
        }
    }

    public void addAttributeChangeNotificationListener(NotificationListener l, String attrName, Object handback) throws MBeanException, RuntimeOperationsException, IllegalArgumentException {
        AttributeChangeNotificationFilter currFilter = new AttributeChangeNotificationFilter();
        currFilter.enableAttribute(attrName);
        this.broadcasterSupport.addNotificationListener(l, currFilter, handback);
    }

    public void removeAttributeChangeNotificationListener(NotificationListener l, String attrName) throws MBeanException, RuntimeOperationsException, ListenerNotFoundException {
        this.broadcasterSupport.removeNotificationListener(l);
    }

    public void sendAttributeChangeNotification(AttributeChangeNotification notification) throws MBeanException, RuntimeOperationsException {
        this.sendNotification(notification);
    }

    public void sendAttributeChangeNotification(Attribute oldAttr, Attribute newAttr) throws MBeanException, RuntimeOperationsException {
        if (!oldAttr.equals(newAttr)) {
            AttributeChangeNotification notification = new AttributeChangeNotification(this.objectName, 1L, new Date().getTime(), "AttributeChange", oldAttr.getName(), newAttr.getValue().getClass().toString(), oldAttr.getValue(), newAttr.getValue());
            this.sendAttributeChangeNotification(notification);
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] result = new MBeanNotificationInfo[2];
        DescriptorSupport genericDescriptor = new DescriptorSupport("name=GENERIC", "descriptorType=notification", "log=T", "severity=5", "displayName=jmx.modelmbean.generic");
        result[0] = new ModelMBeanNotificationInfo(new String[]{"jmx.modelmbean.generic"}, "GENERIC", "A text notification has been issued by the managed resource", genericDescriptor);
        DescriptorSupport attributeDescriptor = new DescriptorSupport("name=ATTRIBUTE_CHANGE", "descriptorType=notification", "log=T", "severity=5", "displayName=jmx.attribute.change");
        result[1] = new ModelMBeanNotificationInfo(new String[]{"jmx.attribute.change"}, "ATTRIBUTE_CHANGE", "Signifies that an observed MBean attribute value has changed", attributeDescriptor);
        return result;
    }

    public void addNotificationListener(NotificationListener l, NotificationFilter filter, Object handle) throws IllegalArgumentException {
        this.broadcasterSupport.addNotificationListener(l, filter, handle);
    }

    public void removeNotificationListener(NotificationListener l) throws ListenerNotFoundException {
        this.broadcasterSupport.removeNotificationListener(l);
    }

    private Object getCurrentValue(CachedAttribute ca) throws MBeanException {
        Object result = null;
        if (ca != null) {
            try {
                result = this.beanUtil.getProperty(ca.getBean(), ca.getName());
            }
            catch (IllegalAccessException e) {
                throw new MBeanException(e);
            }
            catch (InvocationTargetException e) {
                throw new MBeanException(e);
            }
            catch (NoSuchMethodException e) {
                throw new MBeanException(e);
            }
        }
        return result;
    }

    private void buildAttributes(Object obj, MBeanAttributeInfo[] attrs) throws ReflectionException {
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                try {
                    String name = attrs[i].getName();
                    PropertyDescriptor pd = this.beanUtil.getPropertyDescriptor(obj, name);
                    Object value = this.beanUtil.getProperty(obj, name);
                    Attribute attribute = new Attribute(name, value);
                    CachedAttribute ca = new CachedAttribute(attribute);
                    ca.setBean(obj);
                    ca.setPropertyDescriptor(pd);
                    this.cachedAttributes.put(name, ca);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    throw new ReflectionException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ReflectionException(e);
                }
                catch (InvocationTargetException e) {
                    throw new ReflectionException(e);
                }
            }
        }
    }
}

