/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.management;

import javax.jbi.JBIException;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.management.BaseLifeCycle;

public abstract class BaseSystemService
extends BaseLifeCycle {
    protected JBIContainer container;

    public String getName() {
        String name = this.getClass().getName();
        int index = name.lastIndexOf(".");
        if (index >= 0 && index + 1 < name.length()) {
            name = name.substring(index + 1);
        }
        return name;
    }

    public String getType() {
        return "SystemService";
    }

    public void init(JBIContainer container) throws JBIException {
        this.container = container;
        container.getManagementContext().registerSystemService(this, this.getServiceMBean());
    }

    public void shutDown() throws JBIException {
        this.stop();
        super.shutDown();
        if (this.container != null && this.container.getManagementContext() != null) {
            this.container.getManagementContext().unregisterMBean(this);
        }
    }

    protected abstract Class getServiceMBean();

    public JBIContainer getContainer() {
        return this.container;
    }
}

