/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.management;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.apache.servicemix.jbi.management.ParameterHelper;

public class OperationInfoHelper {
    private List list = new ArrayList();

    public ParameterHelper addOperation(Object theObject, String name, String description) {
        return this.addOperation(theObject, name, 0, description);
    }

    public ParameterHelper addOperation(Object theObject, String name, int numberParams, String description) {
        Method method = this.getMethod(theObject.getClass(), name, numberParams);
        MBeanOperationInfo opInfo = new MBeanOperationInfo(description, method);
        this.list.add(opInfo);
        MBeanParameterInfo[] result = opInfo.getSignature();
        return new ParameterHelper(result);
    }

    public MBeanOperationInfo[] getOperationInfos() {
        MBeanOperationInfo[] result = new MBeanOperationInfo[this.list.size()];
        this.list.toArray(result);
        return result;
    }

    public void clear() {
        this.list.clear();
    }

    public static MBeanOperationInfo[] join(MBeanOperationInfo[] ops1, MBeanOperationInfo[] ops2) {
        MBeanOperationInfo[] result = null;
        int length = 0;
        int startPos = 0;
        if (ops1 != null) {
            length = ops1.length;
        }
        if (ops2 != null) {
            length += ops2.length;
        }
        result = new MBeanOperationInfo[length];
        if (ops1 != null) {
            System.arraycopy(ops1, 0, result, startPos, ops1.length);
            startPos = ops1.length;
        }
        if (ops2 != null) {
            System.arraycopy(ops2, 0, result, startPos, ops2.length);
        }
        return result;
    }

    private Method getMethod(Class theClass, String name, int numParams) {
        Method result = null;
        Method[] methods = theClass.getMethods();
        if (methods != null) {
            int i;
            for (i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(name) || methods[i].getParameterTypes().length != numParams) continue;
                result = methods[i];
                break;
            }
            if (result == null) {
                for (i = 0; i < methods.length; ++i) {
                    if (!methods[i].getName().equals(name)) continue;
                    result = methods[i];
                    break;
                }
            }
        }
        return result;
    }
}

