/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.messaging;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.activemq.util.IdGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.jbi.ExchangeTimeoutException;
import org.apache.servicemix.jbi.container.ActivationSpec;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.framework.ComponentContextImpl;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.messaging.MessageExchangeFactoryImpl;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.messaging.MessagingStats;
import org.apache.servicemix.jbi.util.BoundedLinkedQueue;

public class DeliveryChannelImpl
implements DeliveryChannel {
    private static final Log log = LogFactory.getLog((Class)DeliveryChannelImpl.class);
    private JBIContainer container;
    private ComponentContextImpl context;
    private ComponentMBeanImpl component;
    private BoundedLinkedQueue queue = new BoundedLinkedQueue();
    private IdGenerator idGenerator = new IdGenerator();
    private MessageExchangeFactory inboundFactory;
    private int intervalCount = 0;
    private long lastSendTime = System.currentTimeMillis();
    private long lastReceiveTime = System.currentTimeMillis();
    private AtomicBoolean closed = new AtomicBoolean(false);
    private Map waiters = new ConcurrentHashMap();
    private Map exchangesById = new ConcurrentHashMap();

    public DeliveryChannelImpl(ComponentMBeanImpl component) {
        this.component = component;
        this.container = component.getContainer();
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public int getQueueCapacity() {
        return this.queue.capacity();
    }

    public void setQueueCapacity(int value) {
        this.queue.setCapacity(value);
    }

    public void close() throws MessagingException {
        if (this.closed.compareAndSet(false, true)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Closing DeliveryChannel " + this));
            }
            List pending = this.queue.closeAndFlush();
            Iterator iter = pending.iterator();
            while (iter.hasNext()) {
                MessageExchangeImpl messageExchange = (MessageExchangeImpl)iter.next();
                if (messageExchange.getTransactionContext() == null || messageExchange.getMirror().getSyncState() != 1) continue;
                this.notifyExchange(messageExchange.getMirror(), messageExchange.getMirror(), "close");
            }
            Object[] threads = this.waiters.keySet().toArray();
            for (int i = 0; i < threads.length; ++i) {
                ((Thread)threads[i]).interrupt();
            }
            ServiceEndpoint[] endpoints = this.container.getRegistry().getEndpointsForComponent(this.component.getComponentNameSpace());
            for (int i = 0; i < endpoints.length; ++i) {
                try {
                    this.component.getContext().deactivateEndpoint(endpoints[i]);
                    continue;
                }
                catch (JBIException e) {
                    log.error((Object)"Error deactivating endpoint", (Throwable)e);
                }
            }
        }
    }

    protected void checkNotClosed() throws MessagingException {
        if (this.closed.get()) {
            throw new MessagingException(this + " has been closed.");
        }
    }

    public MessageExchangeFactory createExchangeFactory() {
        MessageExchangeFactoryImpl result = this.createMessageExchangeFactory();
        result.setContext(this.context);
        ActivationSpec activationSpec = this.context.getActivationSpec();
        if (activationSpec != null) {
            String endpointName;
            QName operationName;
            QName interfaceName;
            String componentName = this.context.getComponentNameSpace().getName();
            QName serviceName = activationSpec.getDestinationService();
            if (serviceName != null) {
                result.setServiceName(serviceName);
                log.debug((Object)("default destination serviceName for " + componentName + " = " + serviceName));
            }
            if ((interfaceName = activationSpec.getDestinationInterface()) != null) {
                result.setInterfaceName(interfaceName);
                log.debug((Object)("default destination interfaceName for " + componentName + " = " + interfaceName));
            }
            if ((operationName = activationSpec.getDestinationOperation()) != null) {
                result.setOperationName(operationName);
                log.debug((Object)("default destination operationName for " + componentName + " = " + operationName));
            }
            if ((endpointName = activationSpec.getDestinationEndpoint()) != null) {
                boolean endpointSet = false;
                log.debug((Object)("default destination endpointName for " + componentName + " = " + endpointName));
                if (serviceName != null && endpointName != null) {
                    endpointName = endpointName.trim();
                    ServiceEndpoint endpoint = this.container.getRegistry().getEndpoint(serviceName, endpointName);
                    if (endpoint != null) {
                        result.setEndpoint(endpoint);
                        log.info((Object)("Set default destination endpoint for " + componentName + " to " + endpoint));
                        endpointSet = true;
                    }
                }
                if (!endpointSet) {
                    log.warn((Object)("Could not find destination endpoint for " + componentName + " service(" + serviceName + ") with endpointName " + endpointName));
                }
            }
        }
        return result;
    }

    public MessageExchangeFactory createExchangeFactory(QName interfaceName) {
        MessageExchangeFactoryImpl result = this.createMessageExchangeFactory();
        result.setInterfaceName(interfaceName);
        return result;
    }

    public MessageExchangeFactory createExchangeFactoryForService(QName serviceName) {
        MessageExchangeFactoryImpl result = this.createMessageExchangeFactory();
        result.setServiceName(serviceName);
        return result;
    }

    public MessageExchangeFactory createExchangeFactory(ServiceEndpoint endpoint) {
        MessageExchangeFactoryImpl result = this.createMessageExchangeFactory();
        result.setEndpoint(endpoint);
        return result;
    }

    protected MessageExchangeFactoryImpl createMessageExchangeFactory() {
        MessageExchangeFactoryImpl messageExchangeFactory = new MessageExchangeFactoryImpl(this.idGenerator, this.closed);
        messageExchangeFactory.setContext(this.context);
        return messageExchangeFactory;
    }

    public MessageExchange accept() throws MessagingException {
        return this.accept(Long.MAX_VALUE);
    }

    public MessageExchange accept(long timeoutMS) throws MessagingException {
        try {
            this.checkNotClosed();
            MessageExchangeImpl me = (MessageExchangeImpl)this.queue.poll(timeoutMS);
            if (me != null) {
                if (me.getPacket().isAborted()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Aborted " + me.getExchangeId() + " in " + this));
                    }
                    me = null;
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Accepting " + me.getExchangeId() + " in " + this));
                    }
                    if (me.getTxLock() != null && me.getStatus() != ExchangeStatus.ACTIVE) {
                        this.notifyExchange(me.getMirror(), me.getTxLock(), "acceptFinishedExchangeWithTxLock");
                        me.handleAccept();
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Accepted: " + me));
                        }
                    } else if (me.isTransacted() && me.getStatus() != ExchangeStatus.ACTIVE) {
                        me.handleAccept();
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Accepted: " + me));
                        }
                    } else {
                        this.resumeTx(me);
                        me.handleAccept();
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Accepted: " + me));
                        }
                    }
                }
            }
            return me;
        }
        catch (InterruptedException e) {
            throw new MessagingException("accept failed", (Throwable)e);
        }
    }

    protected void autoSetPersistent(MessageExchangeImpl me) {
        Boolean persistent = me.getPersistent();
        if (persistent == null) {
            persistent = this.context.getActivationSpec().getPersistent() != null ? this.context.getActivationSpec().getPersistent() : Boolean.valueOf(this.context.getContainer().isPersistent());
            me.setPersistent(persistent);
        }
    }

    protected void throttle() {
        if (this.component.isExchangeThrottling()) {
            if (this.component.getThrottlingInterval() > this.intervalCount) {
                this.intervalCount = 0;
                try {
                    Thread.sleep(this.component.getThrottlingTimeout());
                }
                catch (InterruptedException e) {
                    log.warn((Object)"throttling failed", (Throwable)e);
                }
            }
            ++this.intervalCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSend(MessageExchangeImpl me, boolean sync) throws MessagingException {
        MessageExchangeImpl mirror = me.getMirror();
        boolean finished = me.getStatus() != ExchangeStatus.ACTIVE;
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Sent: " + me));
            }
            if (me.getPacket().isAborted()) {
                throw new ExchangeTimeoutException(me);
            }
            this.autoEnlistInTx(me);
            this.autoSetPersistent(me);
            this.throttle();
            this.incrementOutboundStats();
            if (me.getRole() == MessageExchange.Role.CONSUMER) {
                me.setSourceId(this.component.getComponentNameSpace());
            }
            this.container.callListeners(me);
            me.handleSend(sync);
            mirror.setTxState(0);
            if (finished && me.getTxLock() == null && me.getTxState() == 2 && !me.isPushDelivery() && me.getRole() == MessageExchange.Role.CONSUMER) {
                me.setTransactionContext(null);
            }
            this.container.sendExchange(mirror);
        }
        catch (MessagingException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception processing: " + me.getExchangeId() + " in " + this));
            }
            throw e;
        }
        finally {
            if (me.getTxLock() != null) {
                if (mirror.getTxState() == 1) {
                    this.suspendTx(mirror);
                }
                Object object = me.getTxLock();
                synchronized (object) {
                    this.notifyExchange(me, me.getTxLock(), "doSendWithTxLock");
                }
            }
        }
    }

    public void send(MessageExchange messageExchange) throws MessagingException {
        this.checkNotClosed();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Send " + messageExchange.getExchangeId() + " in " + this));
        }
        messageExchange.setProperty("javax.jbi.messaging.sendSync", null);
        MessageExchangeImpl me = (MessageExchangeImpl)messageExchange;
        this.doSend(me, false);
    }

    public boolean sendSync(MessageExchange messageExchange) throws MessagingException {
        return this.sendSync(messageExchange, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendSync(MessageExchange messageExchange, long timeout) throws MessagingException {
        this.checkNotClosed();
        if (log.isDebugEnabled()) {
            log.debug((Object)("SendSync " + messageExchange.getExchangeId() + " in " + this));
        }
        boolean result = false;
        messageExchange.setProperty("javax.jbi.messaging.sendSync", (Object)Boolean.TRUE);
        MessageExchangeImpl me = (MessageExchangeImpl)messageExchange;
        try {
            this.exchangesById.put(me.getExchangeId(), me);
            MessageExchangeImpl messageExchangeImpl = me;
            synchronized (messageExchangeImpl) {
                this.doSend(me, true);
                if (me.getSyncState() != 2) {
                    this.waitForExchange(me, me, timeout, "sendSync");
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Exchange " + messageExchange.getExchangeId() + " has already been answered (no need to wait)"));
                }
            }
            if (me.getSyncState() == 2) {
                me.handleAccept();
                this.resumeTx(me);
                result = true;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Exchange " + messageExchange.getExchangeId() + " has been aborted"));
                }
                me.getPacket().setAborted(true);
                result = false;
            }
        }
        catch (InterruptedException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.exchangesById.remove(messageExchange.getExchangeId());
        }
        return result;
    }

    public JBIContainer getContainer() {
        return this.container;
    }

    public void setContainer(JBIContainer container) {
        this.container = container;
    }

    public ComponentMBeanImpl getComponent() {
        return this.component;
    }

    public ComponentContextImpl getContext() {
        return this.context;
    }

    public void setContext(ComponentContextImpl context) {
        this.context = context;
    }

    protected void incrementInboundStats() {
        MessagingStats messagingStats = this.component.getMessagingStats();
        long currentTime = System.currentTimeMillis();
        if (this.container.isNotifyStatistics()) {
            long oldCount = messagingStats.getInboundExchanges().getCount();
            messagingStats.getInboundExchanges().increment();
            this.component.firePropertyChanged("inboundExchangeCount", new Long(oldCount), new Long(messagingStats.getInboundExchanges().getCount()));
            double oldRate = messagingStats.getInboundExchangeRate().getAverageTime();
            messagingStats.getInboundExchangeRate().addTime(currentTime - this.lastReceiveTime);
            this.component.firePropertyChanged("inboundExchangeRate", new Double(oldRate), new Double(messagingStats.getInboundExchangeRate().getAverageTime()));
        } else {
            messagingStats.getInboundExchanges().increment();
            messagingStats.getInboundExchangeRate().addTime(currentTime - this.lastReceiveTime);
        }
        this.lastReceiveTime = currentTime;
    }

    protected void incrementOutboundStats() {
        MessagingStats messagingStats = this.component.getMessagingStats();
        long currentTime = System.currentTimeMillis();
        if (this.container.isNotifyStatistics()) {
            long oldCount = messagingStats.getOutboundExchanges().getCount();
            messagingStats.getOutboundExchanges().increment();
            this.component.firePropertyChanged("outboundExchangeCount", new Long(oldCount), new Long(messagingStats.getOutboundExchanges().getCount()));
            double oldRate = messagingStats.getOutboundExchangeRate().getAverageTime();
            messagingStats.getOutboundExchangeRate().addTime(currentTime - this.lastSendTime);
            this.component.firePropertyChanged("outboundExchangeRate", new Double(oldRate), new Double(messagingStats.getOutboundExchangeRate().getAverageTime()));
        } else {
            messagingStats.getOutboundExchanges().increment();
            messagingStats.getOutboundExchangeRate().addTime(currentTime - this.lastSendTime);
        }
        this.lastSendTime = currentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processInBound(MessageExchangeImpl me) throws MessagingException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Processing inbound exchange: " + me));
        }
        this.checkNotClosed();
        this.incrementInboundStats();
        MessageExchangeImpl original = (MessageExchangeImpl)this.exchangesById.get(me.getExchangeId());
        if (original != null && me != original) {
            original.copyFrom(me);
            me = original;
        }
        if (me.getSyncState() == 1) {
            this.suspendTx(original);
            me.setSyncState(2);
            this.notifyExchange(original, original, "processInboundSynchronousExchange");
            return;
        }
        MessageExchangeListener listener = this.getExchangeListener();
        if (listener != null) {
            me.handleAccept();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Received: " + me));
            }
            me.setPushDeliver(true);
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.component.getComponent().getClass().getClassLoader());
                listener.onMessageExchange(me);
                return;
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        if (me.isTransacted() && me.getStatus() == ExchangeStatus.ACTIVE) {
            Object lock;
            if (me.getTxState() == 2) {
                try {
                    this.suspendTx(me);
                    this.queue.put(me);
                    return;
                }
                catch (InterruptedException e) {
                    log.debug((Object)("Exchange " + me.getExchangeId() + " aborted due to thread interruption"), (Throwable)e);
                    me.getPacket().setAborted(true);
                }
                return;
            }
            Object object = lock = new Object();
            synchronized (object) {
                try {
                    me.setTxLock(lock);
                    this.suspendTx(me);
                    this.queue.put(me);
                    this.waitForExchange(me, lock, 0L, "processInboundTransactionalExchange");
                }
                catch (InterruptedException e) {
                    log.debug((Object)("Exchange " + me.getExchangeId() + " aborted due to thread interruption"), (Throwable)e);
                    me.getPacket().setAborted(true);
                }
                finally {
                    me.setTxLock(null);
                    this.resumeTx(me);
                }
                return;
            }
        }
        try {
            this.queue.put(me);
            return;
        }
        catch (InterruptedException e) {
            log.debug((Object)("Exchange " + me.getExchangeId() + " aborted due to thread interruption"), (Throwable)e);
            me.getPacket().setAborted(true);
        }
    }

    protected MessageExchangeListener getExchangeListener() {
        Component component = this.component.getComponent();
        if (component instanceof MessageExchangeListener) {
            return (MessageExchangeListener)component;
        }
        ComponentLifeCycle lifecycle = this.component.getLifeCycle();
        if (lifecycle instanceof MessageExchangeListener) {
            return (MessageExchangeListener)lifecycle;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForExchange(MessageExchangeImpl me, Object lock, long timeout, String from) throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Waiting for exchange " + me.getExchangeId() + " (" + Integer.toHexString(me.hashCode()) + ") to be answered in " + this + " from " + from));
        }
        Thread th = Thread.currentThread();
        try {
            this.waiters.put(th, Boolean.TRUE);
            lock.wait(timeout);
        }
        finally {
            this.waiters.remove(th);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Notified: " + me.getExchangeId() + "(" + Integer.toHexString(me.hashCode()) + ") in " + this + " from " + from));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyExchange(MessageExchangeImpl me, Object lock, String from) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Notifying exchange " + me.getExchangeId() + "(" + Integer.toHexString(me.hashCode()) + ") in " + this + " from " + from));
        }
        Object object = lock;
        synchronized (object) {
            lock.notify();
        }
    }

    public MessageExchangeFactory getInboundFactory() {
        if (this.inboundFactory == null) {
            this.inboundFactory = this.createExchangeFactory();
        }
        return this.inboundFactory;
    }

    protected void suspendTx(MessageExchangeImpl me) {
        try {
            TransactionManager tm;
            Transaction oldTx = me.getTransactionContext();
            if (oldTx != null && (tm = (TransactionManager)this.container.getTransactionManager()) != null) {
                Transaction tx;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Suspending transaction for " + me.getExchangeId() + " in " + this));
                }
                if ((tx = tm.suspend()) != oldTx) {
                    throw new IllegalStateException("the transaction context set in the messageExchange is not bound to the current thread");
                }
            }
        }
        catch (Exception e) {
            log.info((Object)("Exchange " + me.getExchangeId() + " aborted due to transaction exception"), (Throwable)e);
            me.getPacket().setAborted(true);
        }
    }

    protected void resumeTx(MessageExchangeImpl me) throws MessagingException {
        try {
            TransactionManager tm;
            Transaction oldTx = me.getTransactionContext();
            if (oldTx != null && (tm = (TransactionManager)this.container.getTransactionManager()) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resuming transaction for " + me.getExchangeId() + " in " + this));
                }
                tm.resume(oldTx);
            }
        }
        catch (Exception e) {
            throw new MessagingException((Throwable)e);
        }
    }

    protected void autoEnlistInTx(MessageExchangeImpl me) throws MessagingException {
        try {
            Transaction tx;
            TransactionManager tm;
            if (this.container.isAutoEnlistInTransaction() && (tm = (TransactionManager)this.container.getTransactionManager()) != null && (tx = tm.getTransaction()) != null) {
                Transaction oldTx = me.getTransactionContext();
                if (oldTx == null) {
                    me.setTransactionContext(tx);
                } else if (oldTx != tx) {
                    throw new IllegalStateException("the transaction context set in the messageExchange is not bound to the current thread");
                }
            }
        }
        catch (Exception e) {
            throw new MessagingException((Throwable)e);
        }
    }

    public String toString() {
        return "DeliveryChannel{" + this.component.getName() + "}";
    }
}

