/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.messaging;

import org.apache.activemq.management.CountStatisticImpl;
import org.apache.activemq.management.StatisticImpl;
import org.apache.activemq.management.StatsImpl;
import org.apache.activemq.management.TimeStatisticImpl;
import org.apache.activemq.util.IndentPrinter;

public class MessagingStats
extends StatsImpl {
    private String componentName;
    protected CountStatisticImpl inboundExchanges;
    protected CountStatisticImpl outboundExchanges;
    protected TimeStatisticImpl inboundExchangeRate;
    protected TimeStatisticImpl outboundExchangeRate;

    public MessagingStats(String componentName) {
        this.componentName = componentName;
        this.inboundExchanges = new CountStatisticImpl("inboundExchanges", "Number of Inbound MessageExchanges");
        this.outboundExchanges = new CountStatisticImpl("outboundExchanges", "Number of Outbound MessageExchanges");
        this.inboundExchangeRate = new TimeStatisticImpl("inboundExchangeRate", "time taken to process an Exchange");
        this.outboundExchangeRate = new TimeStatisticImpl("outboundExchangeRate", "time taken to send an Exchange");
        this.addStatistic("inboundExchanges", (StatisticImpl)this.inboundExchanges);
        this.addStatistic("outboundExchanges", (StatisticImpl)this.outboundExchanges);
        this.addStatistic("inboundExchangeRate", (StatisticImpl)this.inboundExchangeRate);
        this.addStatistic("outboundExchangeRate", (StatisticImpl)this.outboundExchangeRate);
    }

    public String getComponentName() {
        return this.componentName;
    }

    public TimeStatisticImpl getInboundExchangeRate() {
        return this.inboundExchangeRate;
    }

    public CountStatisticImpl getInboundExchanges() {
        return this.inboundExchanges;
    }

    public TimeStatisticImpl getOutboundExchangeRate() {
        return this.outboundExchangeRate;
    }

    public CountStatisticImpl getOutboundExchanges() {
        return this.outboundExchanges;
    }

    public synchronized void reset() {
        super.reset();
        this.inboundExchanges.reset();
        this.outboundExchanges.reset();
        this.inboundExchangeRate.reset();
        this.outboundExchangeRate.reset();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Component: ");
        buffer.append(this.componentName);
        buffer.append(" { ");
        buffer.append(this.inboundExchanges);
        buffer.append(" ");
        buffer.append(this.inboundExchangeRate);
        buffer.append(" ");
        buffer.append(this.outboundExchanges);
        buffer.append(" ");
        buffer.append(this.outboundExchangeRate);
        buffer.append(" }");
        return buffer.toString();
    }

    public void dump(IndentPrinter out) {
        out.printIndent();
        out.println("Component: ");
        out.print(this.componentName);
        out.println(" {");
        out.incrementIndent();
        out.println((Object)this.inboundExchanges);
        out.printIndent();
        out.println((Object)this.inboundExchangeRate);
        out.printIndent();
        out.println((Object)this.outboundExchanges);
        out.printIndent();
        out.decrementIndent();
        out.printIndent();
        out.println("}");
    }
}

