/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.nmr.flow;

import edu.emory.mathcs.backport.java.util.concurrent.locks.ReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jbi.JBIException;
import javax.jbi.management.LifeCycleMBean;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.framework.ComponentNameSpace;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.BaseLifeCycle;
import org.apache.servicemix.jbi.messaging.ExchangePacket;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.nmr.Broker;
import org.apache.servicemix.jbi.nmr.flow.Flow;
import org.apache.servicemix.jbi.servicedesc.InternalEndpoint;

public abstract class AbstractFlow
extends BaseLifeCycle
implements Flow {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected Broker broker;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Thread suspendThread = null;
    private String name;

    public void init(Broker broker) throws JBIException {
        this.broker = broker;
        ObjectName objectName = broker.getContainer().getManagementContext().createObjectName(this);
        try {
            broker.getContainer().getManagementContext().registerMBean(objectName, this, LifeCycleMBean.class);
        }
        catch (JMException e) {
            throw new JBIException("Failed to register MBean with the ManagementContext", (Throwable)e);
        }
    }

    public void start() throws JBIException {
        super.start();
    }

    public void stop() throws JBIException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Called Flow stop");
        }
        if (this.suspendThread != null) {
            this.suspendThread.interrupt();
        }
        super.stop();
    }

    public void shutDown() throws JBIException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Called Flow shutdown");
        }
        super.shutDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(MessageExchange me) throws JBIException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Called Flow send");
        }
        try {
            this.lock.readLock().lock();
            this.doSend((MessageExchangeImpl)me);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public synchronized void suspend() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Called Flow suspend");
        }
        this.lock.writeLock().lock();
        this.suspendThread = Thread.currentThread();
    }

    public synchronized void resume() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Called Flow resume");
        }
        this.lock.writeLock().unlock();
        this.suspendThread = null;
    }

    protected abstract void doSend(MessageExchangeImpl var1) throws JBIException;

    protected void doRouting(MessageExchangeImpl me) throws MessagingException {
        ComponentNameSpace id = me.getRole() == MessageExchange.Role.PROVIDER ? me.getDestinationId() : me.getSourceId();
        ComponentMBeanImpl lcc = this.broker.getContainer().getRegistry().getComponent(id.getName());
        if (lcc != null) {
            if (lcc.getDeliveryChannel() == null) {
                throw new MessagingException("Component " + id.getName() + " is shut down");
            }
        } else {
            throw new MessagingException("No component named " + id.getName() + " - Couldn't route MessageExchange " + me);
        }
        lcc.getDeliveryChannel().processInBound(me);
    }

    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "description", "The type of flow");
        return AttributeInfoHelper.join(super.getAttributeInfos(), helper.getAttributeInfos());
    }

    protected boolean isPersistent(MessageExchange me) {
        ExchangePacket packet = ((MessageExchangeImpl)me).getPacket();
        if (packet.getPersistent() != null) {
            return packet.getPersistent();
        }
        return this.broker.getContainer().isPersistent();
    }

    protected boolean isTransacted(MessageExchange me) {
        return me.getProperty("javax.jbi.transaction.jta") != null;
    }

    protected boolean isSynchronous(MessageExchange me) {
        Boolean sync = (Boolean)me.getProperty("javax.jbi.messaging.sendSync");
        return sync != null && sync != false;
    }

    protected boolean isClustered(MessageExchange me) {
        MessageExchangeImpl mei = (MessageExchangeImpl)me;
        if (mei.getDestinationId() == null) {
            ServiceEndpoint se = me.getEndpoint();
            if (se instanceof InternalEndpoint) {
                return ((InternalEndpoint)se).isClustered();
            }
            return false;
        }
        String destination = mei.getDestinationId().getContainerName();
        String source = mei.getSourceId().getContainerName();
        return !source.equals(destination);
    }

    public Broker getBroker() {
        return this.broker;
    }

    public String getType() {
        return "Flow";
    }

    public String getName() {
        if (this.name == null) {
            String name = super.getName();
            if (name.endsWith("Flow")) {
                name = name.substring(0, name.length() - 4);
            }
            return name;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

